<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExpandedLineResult StructType
 * @subpackage Structs
 */
class ExpandedLineResult extends AbstractStructBase
{
    /**
     * The status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The lineErrorOrWarningType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $lineErrorOrWarningType;
    /**
     * The paymentOrderStatus
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $paymentOrderStatus;
    /**
     * The message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * The refCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $refCode;
    /**
     * Constructor method for ExpandedLineResult
     * @uses ExpandedLineResult::setStatus()
     * @uses ExpandedLineResult::setLineErrorOrWarningType()
     * @uses ExpandedLineResult::setPaymentOrderStatus()
     * @uses ExpandedLineResult::setMessage()
     * @uses ExpandedLineResult::setRefCode()
     * @param string $status
     * @param int $lineErrorOrWarningType
     * @param string $paymentOrderStatus
     * @param string $message
     * @param string $refCode
     */
    public function __construct($status = null, $lineErrorOrWarningType = null, $paymentOrderStatus = null, $message = null, $refCode = null)
    {
        $this
            ->setStatus($status)
            ->setLineErrorOrWarningType($lineErrorOrWarningType)
            ->setPaymentOrderStatus($paymentOrderStatus)
            ->setMessage($message)
            ->setRefCode($refCode);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\TipaltiLineResultStatus::valueIsValid()
     * @uses \EnumType\TipaltiLineResultStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\ExpandedLineResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipaltiLineResultStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipaltiLineResultStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\TipaltiLineResultStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get lineErrorOrWarningType value
     * @return int
     */
    public function getLineErrorOrWarningType()
    {
        return $this->lineErrorOrWarningType;
    }
    /**
     * Set lineErrorOrWarningType value
     * @param int $lineErrorOrWarningType
     * @return \StructType\ExpandedLineResult
     */
    public function setLineErrorOrWarningType($lineErrorOrWarningType = null)
    {
        // validation for constraint: int
        if (!is_null($lineErrorOrWarningType) && !(is_int($lineErrorOrWarningType) || ctype_digit($lineErrorOrWarningType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineErrorOrWarningType, true), gettype($lineErrorOrWarningType)), __LINE__);
        }
        $this->lineErrorOrWarningType = $lineErrorOrWarningType;
        return $this;
    }
    /**
     * Get paymentOrderStatus value
     * @return string|null
     */
    public function getPaymentOrderStatus()
    {
        return $this->paymentOrderStatus;
    }
    /**
     * Set paymentOrderStatus value
     * @param string $paymentOrderStatus
     * @return \StructType\ExpandedLineResult
     */
    public function setPaymentOrderStatus($paymentOrderStatus = null)
    {
        // validation for constraint: string
        if (!is_null($paymentOrderStatus) && !is_string($paymentOrderStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentOrderStatus, true), gettype($paymentOrderStatus)), __LINE__);
        }
        $this->paymentOrderStatus = $paymentOrderStatus;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \StructType\ExpandedLineResult
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Get refCode value
     * @return string|null
     */
    public function getRefCode()
    {
        return $this->refCode;
    }
    /**
     * Set refCode value
     * @param string $refCode
     * @return \StructType\ExpandedLineResult
     */
    public function setRefCode($refCode = null)
    {
        // validation for constraint: string
        if (!is_null($refCode) && !is_string($refCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refCode, true), gettype($refCode)), __LINE__);
        }
        $this->refCode = $refCode;
        return $this;
    }
}
