<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldValue StructType
 * @subpackage Structs
 */
class CustomFieldValue extends AbstractStructBase
{
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsActive;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Value;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * Constructor method for CustomFieldValue
     * @uses CustomFieldValue::setIsActive()
     * @uses CustomFieldValue::setValue()
     * @uses CustomFieldValue::setCode()
     * @uses CustomFieldValue::setPayerEntityName()
     * @param bool $isActive
     * @param string $value
     * @param string $code
     * @param string $payerEntityName
     */
    public function __construct($isActive = null, $value = null, $code = null, $payerEntityName = null)
    {
        $this
            ->setIsActive($isActive)
            ->setValue($value)
            ->setCode($code)
            ->setPayerEntityName($payerEntityName);
    }
    /**
     * Get IsActive value
     * @return bool
     */
    public function getIsActive()
    {
        return $this->IsActive;
    }
    /**
     * Set IsActive value
     * @param bool $isActive
     * @return \StructType\CustomFieldValue
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        $this->IsActive = $isActive;
        return $this;
    }
    /**
     * Get Value value
     * @return string|null
     */
    public function getValue()
    {
        return $this->Value;
    }
    /**
     * Set Value value
     * @param string $value
     * @return \StructType\CustomFieldValue
     */
    public function setValue($value = null)
    {
        // validation for constraint: string
        if (!is_null($value) && !is_string($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        $this->Value = $value;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\CustomFieldValue
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\CustomFieldValue
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
}
