<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomFieldInfo StructType
 * @subpackage Structs
 */
class CustomFieldInfo extends AbstractStructBase
{
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Entity;
    /**
     * The Title
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Title;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The ValueType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ValueType;
    /**
     * The SubEntity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubEntity;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfCustomFieldValue
     */
    public $Values;
    /**
     * The Category
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Category;
    /**
     * Constructor method for CustomFieldInfo
     * @uses CustomFieldInfo::setEntity()
     * @uses CustomFieldInfo::setTitle()
     * @uses CustomFieldInfo::setDescription()
     * @uses CustomFieldInfo::setValueType()
     * @uses CustomFieldInfo::setSubEntity()
     * @uses CustomFieldInfo::setValues()
     * @uses CustomFieldInfo::setCategory()
     * @param string $entity
     * @param string $title
     * @param string $description
     * @param string $valueType
     * @param string $subEntity
     * @param \ArrayType\ArrayOfCustomFieldValue $values
     * @param string $category
     */
    public function __construct($entity = null, $title = null, $description = null, $valueType = null, $subEntity = null, \ArrayType\ArrayOfCustomFieldValue $values = null, $category = null)
    {
        $this
            ->setEntity($entity)
            ->setTitle($title)
            ->setDescription($description)
            ->setValueType($valueType)
            ->setSubEntity($subEntity)
            ->setValues($values)
            ->setCategory($category);
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \StructType\CustomFieldInfo
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entity, true), gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get Title value
     * @return string|null
     */
    public function getTitle()
    {
        return $this->Title;
    }
    /**
     * Set Title value
     * @param string $title
     * @return \StructType\CustomFieldInfo
     */
    public function setTitle($title = null)
    {
        // validation for constraint: string
        if (!is_null($title) && !is_string($title)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($title, true), gettype($title)), __LINE__);
        }
        $this->Title = $title;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\CustomFieldInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get ValueType value
     * @return string|null
     */
    public function getValueType()
    {
        return $this->ValueType;
    }
    /**
     * Set ValueType value
     * @param string $valueType
     * @return \StructType\CustomFieldInfo
     */
    public function setValueType($valueType = null)
    {
        // validation for constraint: string
        if (!is_null($valueType) && !is_string($valueType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueType, true), gettype($valueType)), __LINE__);
        }
        $this->ValueType = $valueType;
        return $this;
    }
    /**
     * Get SubEntity value
     * @return string|null
     */
    public function getSubEntity()
    {
        return $this->SubEntity;
    }
    /**
     * Set SubEntity value
     * @param string $subEntity
     * @return \StructType\CustomFieldInfo
     */
    public function setSubEntity($subEntity = null)
    {
        // validation for constraint: string
        if (!is_null($subEntity) && !is_string($subEntity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subEntity, true), gettype($subEntity)), __LINE__);
        }
        $this->SubEntity = $subEntity;
        return $this;
    }
    /**
     * Get Values value
     * @return \ArrayType\ArrayOfCustomFieldValue|null
     */
    public function getValues()
    {
        return $this->Values;
    }
    /**
     * Set Values value
     * @param \ArrayType\ArrayOfCustomFieldValue $values
     * @return \StructType\CustomFieldInfo
     */
    public function setValues(\ArrayType\ArrayOfCustomFieldValue $values = null)
    {
        $this->Values = $values;
        return $this;
    }
    /**
     * Get Category value
     * @return string|null
     */
    public function getCategory()
    {
        return $this->Category;
    }
    /**
     * Set Category value
     * @param string $category
     * @return \StructType\CustomFieldInfo
     */
    public function setCategory($category = null)
    {
        // validation for constraint: string
        if (!is_null($category) && !is_string($category)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($category, true), gettype($category)), __LINE__);
        }
        $this->Category = $category;
        return $this;
    }
}
