<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreatePayeeStatusFile StructType
 * @subpackage Structs
 */
class CreatePayeeStatusFile extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The changesSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $changesSinceDate;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The saveToFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $saveToFile;
    /**
     * Constructor method for CreatePayeeStatusFile
     * @uses CreatePayeeStatusFile::setTimestamp()
     * @uses CreatePayeeStatusFile::setChangesSinceDate()
     * @uses CreatePayeeStatusFile::setPayerName()
     * @uses CreatePayeeStatusFile::setKey()
     * @uses CreatePayeeStatusFile::setSaveToFile()
     * @param float $timestamp
     * @param float $changesSinceDate
     * @param string $payerName
     * @param string $key
     * @param string $saveToFile
     */
    public function __construct($timestamp = null, $changesSinceDate = null, $payerName = null, $key = null, $saveToFile = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setChangesSinceDate($changesSinceDate)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setSaveToFile($saveToFile);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\CreatePayeeStatusFile
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get changesSinceDate value
     * @return float
     */
    public function getChangesSinceDate()
    {
        return $this->changesSinceDate;
    }
    /**
     * Set changesSinceDate value
     * @param float $changesSinceDate
     * @return \StructType\CreatePayeeStatusFile
     */
    public function setChangesSinceDate($changesSinceDate = null)
    {
        // validation for constraint: float
        if (!is_null($changesSinceDate) && !(is_float($changesSinceDate) || is_numeric($changesSinceDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($changesSinceDate, true), gettype($changesSinceDate)), __LINE__);
        }
        $this->changesSinceDate = $changesSinceDate;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CreatePayeeStatusFile
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\CreatePayeeStatusFile
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get saveToFile value
     * @return string|null
     */
    public function getSaveToFile()
    {
        return $this->saveToFile;
    }
    /**
     * Set saveToFile value
     * @param string $saveToFile
     * @return \StructType\CreatePayeeStatusFile
     */
    public function setSaveToFile($saveToFile = null)
    {
        // validation for constraint: string
        if (!is_null($saveToFile) && !is_string($saveToFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveToFile, true), gettype($saveToFile)), __LINE__);
        }
        $this->saveToFile = $saveToFile;
        return $this;
    }
}
