<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateOrUpdateInvoices StructType
 * @subpackage Structs
 */
class CreateOrUpdateInvoices extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The invoices
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfTipaltiInvoiceItemRequest
     */
    public $invoices;
    /**
     * Constructor method for CreateOrUpdateInvoices
     * @uses CreateOrUpdateInvoices::setTimestamp()
     * @uses CreateOrUpdateInvoices::setPayerName()
     * @uses CreateOrUpdateInvoices::setKey()
     * @uses CreateOrUpdateInvoices::setInvoices()
     * @param float $timestamp
     * @param string $payerName
     * @param string $key
     * @param \ArrayType\ArrayOfTipaltiInvoiceItemRequest $invoices
     */
    public function __construct($timestamp = null, $payerName = null, $key = null, \ArrayType\ArrayOfTipaltiInvoiceItemRequest $invoices = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setInvoices($invoices);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\CreateOrUpdateInvoices
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CreateOrUpdateInvoices
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\CreateOrUpdateInvoices
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get invoices value
     * @return \ArrayType\ArrayOfTipaltiInvoiceItemRequest|null
     */
    public function getInvoices()
    {
        return $this->invoices;
    }
    /**
     * Set invoices value
     * @param \ArrayType\ArrayOfTipaltiInvoiceItemRequest $invoices
     * @return \StructType\CreateOrUpdateInvoices
     */
    public function setInvoices(\ArrayType\ArrayOfTipaltiInvoiceItemRequest $invoices = null)
    {
        $this->invoices = $invoices;
        return $this;
    }
}
