<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreateExtendedPayeeStatusFile StructType
 * @subpackage Structs
 */
class CreateExtendedPayeeStatusFile extends AbstractStructBase
{
    /**
     * The timestamp
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $timestamp;
    /**
     * The listType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $listType;
    /**
     * The changesSinceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $changesSinceDate;
    /**
     * The payerName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $payerName;
    /**
     * The key
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $key;
    /**
     * The saveToFile
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $saveToFile;
    /**
     * Constructor method for CreateExtendedPayeeStatusFile
     * @uses CreateExtendedPayeeStatusFile::setTimestamp()
     * @uses CreateExtendedPayeeStatusFile::setListType()
     * @uses CreateExtendedPayeeStatusFile::setChangesSinceDate()
     * @uses CreateExtendedPayeeStatusFile::setPayerName()
     * @uses CreateExtendedPayeeStatusFile::setKey()
     * @uses CreateExtendedPayeeStatusFile::setSaveToFile()
     * @param float $timestamp
     * @param int $listType
     * @param float $changesSinceDate
     * @param string $payerName
     * @param string $key
     * @param string $saveToFile
     */
    public function __construct($timestamp = null, $listType = null, $changesSinceDate = null, $payerName = null, $key = null, $saveToFile = null)
    {
        $this
            ->setTimestamp($timestamp)
            ->setListType($listType)
            ->setChangesSinceDate($changesSinceDate)
            ->setPayerName($payerName)
            ->setKey($key)
            ->setSaveToFile($saveToFile);
    }
    /**
     * Get timestamp value
     * @return float
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param float $timestamp
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: float
        if (!is_null($timestamp) && !(is_float($timestamp) || is_numeric($timestamp))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get listType value
     * @return int
     */
    public function getListType()
    {
        return $this->listType;
    }
    /**
     * Set listType value
     * @param int $listType
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setListType($listType = null)
    {
        // validation for constraint: int
        if (!is_null($listType) && !(is_int($listType) || ctype_digit($listType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($listType, true), gettype($listType)), __LINE__);
        }
        $this->listType = $listType;
        return $this;
    }
    /**
     * Get changesSinceDate value
     * @return float
     */
    public function getChangesSinceDate()
    {
        return $this->changesSinceDate;
    }
    /**
     * Set changesSinceDate value
     * @param float $changesSinceDate
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setChangesSinceDate($changesSinceDate = null)
    {
        // validation for constraint: float
        if (!is_null($changesSinceDate) && !(is_float($changesSinceDate) || is_numeric($changesSinceDate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($changesSinceDate, true), gettype($changesSinceDate)), __LINE__);
        }
        $this->changesSinceDate = $changesSinceDate;
        return $this;
    }
    /**
     * Get payerName value
     * @return string|null
     */
    public function getPayerName()
    {
        return $this->payerName;
    }
    /**
     * Set payerName value
     * @param string $payerName
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setPayerName($payerName = null)
    {
        // validation for constraint: string
        if (!is_null($payerName) && !is_string($payerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerName, true), gettype($payerName)), __LINE__);
        }
        $this->payerName = $payerName;
        return $this;
    }
    /**
     * Get key value
     * @return string|null
     */
    public function getKey()
    {
        return $this->key;
    }
    /**
     * Set key value
     * @param string $key
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setKey($key = null)
    {
        // validation for constraint: string
        if (!is_null($key) && !is_string($key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($key, true), gettype($key)), __LINE__);
        }
        $this->key = $key;
        return $this;
    }
    /**
     * Get saveToFile value
     * @return string|null
     */
    public function getSaveToFile()
    {
        return $this->saveToFile;
    }
    /**
     * Set saveToFile value
     * @param string $saveToFile
     * @return \StructType\CreateExtendedPayeeStatusFile
     */
    public function setSaveToFile($saveToFile = null)
    {
        // validation for constraint: string
        if (!is_null($saveToFile) && !is_string($saveToFile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saveToFile, true), gettype($saveToFile)), __LINE__);
        }
        $this->saveToFile = $saveToFile;
        return $this;
    }
}
