<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountInfo StructType
 * @subpackage Structs
 */
class AccountInfo extends AbstractStructBase
{
    /**
     * The Provider
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provider;
    /**
     * The AccountIdentifier
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountIdentifier;
    /**
     * The Currency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Currency;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DisplayName;
    /**
     * The PayerEntityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PayerEntityName;
    /**
     * Constructor method for AccountInfo
     * @uses AccountInfo::setProvider()
     * @uses AccountInfo::setAccountIdentifier()
     * @uses AccountInfo::setCurrency()
     * @uses AccountInfo::setDisplayName()
     * @uses AccountInfo::setPayerEntityName()
     * @param string $provider
     * @param string $accountIdentifier
     * @param string $currency
     * @param string $displayName
     * @param string $payerEntityName
     */
    public function __construct($provider = null, $accountIdentifier = null, $currency = null, $displayName = null, $payerEntityName = null)
    {
        $this
            ->setProvider($provider)
            ->setAccountIdentifier($accountIdentifier)
            ->setCurrency($currency)
            ->setDisplayName($displayName)
            ->setPayerEntityName($payerEntityName);
    }
    /**
     * Get Provider value
     * @return string|null
     */
    public function getProvider()
    {
        return $this->Provider;
    }
    /**
     * Set Provider value
     * @param string $provider
     * @return \StructType\AccountInfo
     */
    public function setProvider($provider = null)
    {
        // validation for constraint: string
        if (!is_null($provider) && !is_string($provider)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provider, true), gettype($provider)), __LINE__);
        }
        $this->Provider = $provider;
        return $this;
    }
    /**
     * Get AccountIdentifier value
     * @return string|null
     */
    public function getAccountIdentifier()
    {
        return $this->AccountIdentifier;
    }
    /**
     * Set AccountIdentifier value
     * @param string $accountIdentifier
     * @return \StructType\AccountInfo
     */
    public function setAccountIdentifier($accountIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($accountIdentifier) && !is_string($accountIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIdentifier, true), gettype($accountIdentifier)), __LINE__);
        }
        $this->AccountIdentifier = $accountIdentifier;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\AccountInfo
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Get DisplayName value
     * @return string|null
     */
    public function getDisplayName()
    {
        return $this->DisplayName;
    }
    /**
     * Set DisplayName value
     * @param string $displayName
     * @return \StructType\AccountInfo
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        $this->DisplayName = $displayName;
        return $this;
    }
    /**
     * Get PayerEntityName value
     * @return string|null
     */
    public function getPayerEntityName()
    {
        return $this->PayerEntityName;
    }
    /**
     * Set PayerEntityName value
     * @param string $payerEntityName
     * @return \StructType\AccountInfo
     */
    public function setPayerEntityName($payerEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($payerEntityName) && !is_string($payerEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payerEntityName, true), gettype($payerEntityName)), __LINE__);
        }
        $this->PayerEntityName = $payerEntityName;
        return $this;
    }
}
