<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Test ServiceType
 * @subpackage Services
 */
class Test extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TestPaymentFile
     * Meta information extracted from the WSDL
     * - documentation: Test a payment file. File should be pre-loaded to the SFTP folder assigned by Tipalti.Return value includes warnings and errors, including line number in file. An 'OK' errorMessage means that the payment file can be submitted. NO
     * PAYMENTS WILL BE EXECUTED.<br/>EAT - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestPaymentFile $parameters
     * @return \StructType\TestPaymentFileResponse|bool
     */
    public function TestPaymentFile(\StructType\TestPaymentFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestPaymentFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestMultiCurrencyPaymentFile
     * Meta information extracted from the WSDL
     * - documentation: Test a payment file. File should be pre-loaded to the SFTP folder assigned by Tipalti.Return value includes warnings and errors, including line number in file. An 'OK' errorMessage means that the payment file can be submitted. NO
     * PAYMENTS WILL BE EXECUTED.<br/>EAT - fileName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestMultiCurrencyPaymentFile $parameters
     * @return \StructType\TestMultiCurrencyPaymentFileResponse|bool
     */
    public function TestMultiCurrencyPaymentFile(\StructType\TestMultiCurrencyPaymentFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestMultiCurrencyPaymentFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestPayments
     * Meta information extracted from the WSDL
     * - documentation: Test payments in a list.<br/>Return value includes warnings and errors.<br/> Payment list can be no more than 250 item long. NO PAYMENTS WILL BE EXECUTED<br/>EAT - paymentGroupTitle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestPayments $parameters
     * @return \StructType\TestPaymentsResponse|bool
     */
    public function TestPayments(\StructType\TestPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestPaymentsAsync
     * Meta information extracted from the WSDL
     * - documentation: Test payments in a list asynchronously. <br/>Return value includes warnings, errors and request idRequest id can be used to check the processing status and get the processing result.<br/>Payment list can be no more than 250 item
     * long. <br/>EAT - paymentGroupTitle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestPaymentsAsync $parameters
     * @return \StructType\TestPaymentsAsyncResponse|bool
     */
    public function TestPaymentsAsync(\StructType\TestPaymentsAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestPaymentsAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestPaymentFileAsync
     * Meta information extracted from the WSDL
     * - documentation: Test payment file asynchronously. <br/>File should be pre-loaded to the SFTP folder assigned by Tipalti. <br/>Return value includes warnings, errors, and request idRequest id can be used to check the processing status and get the
     * processing result.<br/>EAT - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestPaymentFileAsync $parameters
     * @return \StructType\TestPaymentFileAsyncResponse|bool
     */
    public function TestPaymentFileAsync(\StructType\TestPaymentFileAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestPaymentFileAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TestMultiCurrencyPaymentFileAsync
     * Meta information extracted from the WSDL
     * - documentation: Test a multi currency payment file asynchronously. <br/>File should be pre-loaded to the SFTP folder assigned by Tipalti. <br/>Return value includes warnings, errors, and request idRequest id can be used to check the processing
     * status and get the processing result.<br/>EAT - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TestMultiCurrencyPaymentFileAsync $parameters
     * @return \StructType\TestMultiCurrencyPaymentFileAsyncResponse|bool
     */
    public function TestMultiCurrencyPaymentFileAsync(\StructType\TestMultiCurrencyPaymentFileAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->TestMultiCurrencyPaymentFileAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TestMultiCurrencyPaymentFileAsyncResponse|\StructType\TestMultiCurrencyPaymentFileResponse|\StructType\TestPaymentFileAsyncResponse|\StructType\TestPaymentFileResponse|\StructType\TestPaymentsAsyncResponse|\StructType\TestPaymentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
