<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessPaymentFile
     * Meta information extracted from the WSDL
     * - documentation: Submit file for payment. File should be pre-loaded to the SFTP folder assigned by Tipalti.Return value includes warnings and errors, including line number in file. An 'OK' errorMessage means that the payments were submitted.<br/>EAT
     * - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPaymentFile $parameters
     * @return \StructType\ProcessPaymentFileResponse|bool
     */
    public function ProcessPaymentFile(\StructType\ProcessPaymentFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPaymentFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessMultiCurrencyPaymentFile
     * Meta information extracted from the WSDL
     * - documentation: Submit file for payment. File should be pre-loaded to the SFTP folder assigned by Tipalti.Return value includes warnings and errors, including line number in file. An 'OK' errorMessage means that the payments were submitted.<br/>EAT
     * - fileName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessMultiCurrencyPaymentFile $parameters
     * @return \StructType\ProcessMultiCurrencyPaymentFileResponse|bool
     */
    public function ProcessMultiCurrencyPaymentFile(\StructType\ProcessMultiCurrencyPaymentFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessMultiCurrencyPaymentFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPayments
     * Meta information extracted from the WSDL
     * - documentation: Process payments in a list. <br/>Return value includes warnings and errors. <br/>Payment list can be no more than 250 item long. <br/>EAT - paymentGroupTitle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPayments $parameters
     * @return \StructType\ProcessPaymentsResponse|bool
     */
    public function ProcessPayments(\StructType\ProcessPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPaymentsAsync
     * Meta information extracted from the WSDL
     * - documentation: Process payments in a list asynchronously. <br/>Return value includes warnings, errors and request idRequest id can be used to check the processing status and get the processing result.<br/>Payment list can be no more than 250 item
     * long. <br/>EAT - paymentGroupTitle
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPaymentsAsync $parameters
     * @return \StructType\ProcessPaymentsAsyncResponse|bool
     */
    public function ProcessPaymentsAsync(\StructType\ProcessPaymentsAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPaymentsAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPaymentFileAsync
     * Meta information extracted from the WSDL
     * - documentation: Process file for payment asynchronously. <br/>File should be pre-loaded to the SFTP folder assigned by Tipalti. <br/>Return value includes warnings, errors, and request idRequest id can be used to check the processing status and get
     * the processing result.<br/>EAT - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPaymentFileAsync $parameters
     * @return \StructType\ProcessPaymentFileAsyncResponse|bool
     */
    public function ProcessPaymentFileAsync(\StructType\ProcessPaymentFileAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPaymentFileAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ProcessMultiCurrencyPaymentFileAsync
     * Meta information extracted from the WSDL
     * - documentation: Process a multi currency payment file asynchronously. <br/>File should be pre-loaded to the SFTP folder assigned by Tipalti. <br/>Return value includes warnings, errors, and request idRequest id can be used to check the processing
     * status and get the processing result.<br/>EAT - totalAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessMultiCurrencyPaymentFileAsync $parameters
     * @return \StructType\ProcessMultiCurrencyPaymentFileAsyncResponse|bool
     */
    public function ProcessMultiCurrencyPaymentFileAsync(\StructType\ProcessMultiCurrencyPaymentFileAsync $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessMultiCurrencyPaymentFileAsync($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessPaymentsAsyncResult
     * Meta information extracted from the WSDL
     * - documentation: Returns the result of an ansynchronous process payments call. <br/>Return value includes warnings and errors. <br/>EAT - requestId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessPaymentsAsyncResult $parameters
     * @return \StructType\ProcessPaymentsAsyncResultResponse|bool
     */
    public function ProcessPaymentsAsyncResult(\StructType\ProcessPaymentsAsyncResult $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessPaymentsAsyncResult($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessMultiCurrencyPaymentFileAsyncResponse|\StructType\ProcessMultiCurrencyPaymentFileResponse|\StructType\ProcessPaymentFileAsyncResponse|\StructType\ProcessPaymentFileResponse|\StructType\ProcessPaymentsAsyncResponse|\StructType\ProcessPaymentsAsyncResultResponse|\StructType\ProcessPaymentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
