<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetCustomFields
     * Meta information extracted from the WSDL
     * - documentation: Return the payer custom fields
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCustomFields $parameters
     * @return \StructType\GetCustomFieldsResponse|bool
     */
    public function GetCustomFields(\StructType\GetCustomFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProviderAccounts
     * Meta information extracted from the WSDL
     * - documentation: Return the payer provider accounts info
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProviderAccounts $parameters
     * @return \StructType\GetProviderAccountsResponse|bool
     */
    public function GetProviderAccounts(\StructType\GetProviderAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProviderAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDynamicKeyOfSubPayer
     * Meta information extracted from the WSDL
     * - documentation: Get dynamic encryption key of sub payer. the dynamic key is encrypted with the parent payer key.The SecurityToken object returns contains an encrypted key and a token. Use the key to sign the query string.<br>You must send the token
     * within the query string of the iFrame. To do that, set its value to a Query String parameter named 'token'.<br>The key is a temporary key and will expire within the time limit you have set in the administration console.<br><b>Do not send the key over
     * the wire or include it in the query string. Store it in a secure location.</b></br>EAT - subPayerName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDynamicKeyOfSubPayer $parameters
     * @return \StructType\GetDynamicKeyOfSubPayerResponse|bool
     */
    public function GetDynamicKeyOfSubPayer(\StructType\GetDynamicKeyOfSubPayer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDynamicKeyOfSubPayer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetProcessingRequestStatus
     * Meta information extracted from the WSDL
     * - documentation: Returns the current status of an ansynchronous processing request. <br/>Return value includes warnings and errors. <br/>EAT - requestId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetProcessingRequestStatus $parameters
     * @return \StructType\GetProcessingRequestStatusResponse|bool
     */
    public function GetProcessingRequestStatus(\StructType\GetProcessingRequestStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetProcessingRequestStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDynamicKey
     * Meta information extracted from the WSDL
     * - documentation: Returns a dynamic security key that can be used to sign the content of the Tipalti iFrame Query String.<br>The SecurityToken object returns contains a key and a token. Use the key to sign the query string.<br>You must send the token
     * within the query string of the iFrame. To do that, set its value to a Query String parameter named 'token'<br>The key is a temporary key and will expire within the time limit you have set in the administration console<br><b>Do not send the key over
     * the wire or include it in the query string. Store it in a secure location.</b></br> EAT - none
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDynamicKey $parameters
     * @return \StructType\GetDynamicKeyResponse|bool
     */
    public function GetDynamicKey(\StructType\GetDynamicKey $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDynamicKey($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetBalances
     * Meta information extracted from the WSDL
     * - documentation: Get balances in your accounts. Returns account provider, account identifier, currency and amount in balance.<br/>Note: when submitting a payment, the balance may take some time before it is updated<br/>EAT - none
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetBalances $parameters
     * @return \StructType\GetBalancesResponse|bool
     */
    public function GetBalances(\StructType\GetBalances $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetBalances($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUpdatedPayments
     * Meta information extracted from the WSDL
     * - documentation: Return ref codes of POs which were updated since a given timestamp.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUpdatedPayments $parameters
     * @return \StructType\GetUpdatedPaymentsResponse|bool
     */
    public function GetUpdatedPayments(\StructType\GetUpdatedPayments $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUpdatedPayments($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayerFees
     * Meta information extracted from the WSDL
     * - documentation: Return list of payer fees charged between specific dates.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPayerFees $parameters
     * @return \StructType\GetPayerFeesResponse|bool
     */
    public function GetPayerFees(\StructType\GetPayerFees $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPayerFees($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayeeInvoicesListDetails
     * Meta information extracted from the WSDL
     * - documentation: Return list of payee invoices.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPayeeInvoicesListDetails $parameters
     * @return \StructType\GetPayeeInvoicesListDetailsResponse|bool
     */
    public function GetPayeeInvoicesListDetails(\StructType\GetPayeeInvoicesListDetails $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPayeeInvoicesListDetails($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPaymentTerms
     * Meta information extracted from the WSDL
     * - documentation: Gets all the payer payment terms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPaymentTerms $parameters
     * @return \StructType\GetPaymentTermsResponse|bool
     */
    public function GetPaymentTerms(\StructType\GetPaymentTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPaymentTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayerEntities
     * Meta information extracted from the WSDL
     * - documentation: Gets all the payer entities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPayerEntities $parameters
     * @return \StructType\GetPayerEntitiesResponse|bool
     */
    public function GetPayerEntities(\StructType\GetPayerEntities $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPayerEntities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPayeeInvoiceFile
     * Meta information extracted from the WSDL
     * - documentation: Gets the invoice file by refcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPayeeInvoiceFile $parameters
     * @return \StructType\GetPayeeInvoiceFileResponse|bool
     */
    public function GetPayeeInvoiceFile(\StructType\GetPayeeInvoiceFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPayeeInvoiceFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetBalancesResponse|\StructType\GetCustomFieldsResponse|\StructType\GetDynamicKeyOfSubPayerResponse|\StructType\GetDynamicKeyResponse|\StructType\GetPayeeInvoiceFileResponse|\StructType\GetPayeeInvoicesListDetailsResponse|\StructType\GetPayerEntitiesResponse|\StructType\GetPayerFeesResponse|\StructType\GetPaymentTermsResponse|\StructType\GetProcessingRequestStatusResponse|\StructType\GetProviderAccountsResponse|\StructType\GetUpdatedPaymentsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
