<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreatePaymentOrdersReport
     * Meta information extracted from the WSDL
     * - documentation: Create payment orders report. Return value is the report file name that is written to the SFTP folder. </br>The details file format may change over time. Columns may be added. When reading the file ensure you have functionality that
     * can ignore new, additional, columns.</br>The report is on all the payment orders between startTime and endTime parameters.<br/>EAT - none
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePaymentOrdersReport $parameters
     * @return \StructType\CreatePaymentOrdersReportResponse|bool
     */
    public function CreatePaymentOrdersReport(\StructType\CreatePaymentOrdersReport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePaymentOrdersReport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateExtendedPayeeStatusFile
     * Meta information extracted from the WSDL
     * - documentation: Create a file with the status of all payees in the system.<br/>listType possible values: (1-All (Default),2-Payable,3-UnPayable).<br/>changesSinceDate is an optional parameter to limit the report to the payees that changed their info
     * since that date.<br/>The CSV file is placed in the payer's SFTP folder. If a file by this name already exists, it will be removed.<br/> EAT - saveToFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateExtendedPayeeStatusFile $parameters
     * @return \StructType\CreateExtendedPayeeStatusFileResponse|bool
     */
    public function CreateExtendedPayeeStatusFile(\StructType\CreateExtendedPayeeStatusFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateExtendedPayeeStatusFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreatePayeeStatusFile
     * Meta information extracted from the WSDL
     * - documentation: Create a file with the status of all payees in the system.<br/>changesSinceDate is an optional paramter to limit the report to the payees that changed their info since that date.<br/>The CSV file is placed in the payer's SFTP folder
     * and has the following format: payee ID, payment method, status, reason.<br/>If a file by this name already exists, it will be removed.<br/> EAT - saveToFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreatePayeeStatusFile $parameters
     * @return \StructType\CreatePayeeStatusFileResponse|bool
     */
    public function CreatePayeeStatusFile(\StructType\CreatePayeeStatusFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreatePayeeStatusFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateInvoices
     * Meta information extracted from the WSDL
     * - documentation: create new invoices or update existing ones.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateInvoices $parameters
     * @return \StructType\CreateOrUpdateInvoicesResponse|bool
     */
    public function CreateOrUpdateInvoices(\StructType\CreateOrUpdateInvoices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateGLAccounts
     * Meta information extracted from the WSDL
     * - documentation: Creates, updates or closes G/L accounts.<br/>If G/L Account does not exist, it will be created.<br/> If G/L Account is closed, it will be updated and reactivated.<br/>If G/L account is assigned to outstanding unpaid bill(s), Close
     * action will be rejected.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateGLAccounts $parameters
     * @return \StructType\CreateOrUpdateGLAccountsResponse|bool
     */
    public function CreateOrUpdateGLAccounts(\StructType\CreateOrUpdateGLAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateGLAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateCustomFields
     * Meta information extracted from the WSDL
     * - documentation: Create update or delete custom fields. Custom fields type can be created as: .<br/>1. Free text - the user can enter any free text.<br/>2. Unique text - the value can enter any text. The value will be validated as unique.<br/>3.
     * Multiple values - the user can select multiple values from a predefined list of values.<br/>4. List of values - the user can select a single value from a predefined list of values. <br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateCustomFields $parameters
     * @return \StructType\CreateOrUpdateCustomFieldsResponse|bool
     */
    public function CreateOrUpdateCustomFields(\StructType\CreateOrUpdateCustomFields $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateCustomFields($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateCustomFieldValue
     * Meta information extracted from the WSDL
     * - documentation: Create, update or delete a custom field value for custom fields of type ListOfValues or MultipleValues.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateCustomFieldValue $parameters
     * @return \StructType\CreateOrUpdateCustomFieldValueResponse|bool
     */
    public function CreateOrUpdateCustomFieldValue(\StructType\CreateOrUpdateCustomFieldValue $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateCustomFieldValue($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateGrns
     * Meta information extracted from the WSDL
     * - documentation: Create new goods recieved notifications or update existing ones.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateGrns $parameters
     * @return \StructType\CreateOrUpdateGrnsResponse|bool
     */
    public function CreateOrUpdateGrns(\StructType\CreateOrUpdateGrns $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateGrns($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdatePurchaseOrders
     * Meta information extracted from the WSDL
     * - documentation: Create new purchase orders or update existing ones.<br/>EAT - null
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdatePurchaseOrders $parameters
     * @return \StructType\CreateOrUpdatePurchaseOrdersResponse|bool
     */
    public function CreateOrUpdatePurchaseOrders(\StructType\CreateOrUpdatePurchaseOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdatePurchaseOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdatePaymentTerms
     * Meta information extracted from the WSDL
     * - documentation: Create or update payment terms
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdatePaymentTerms $parameters
     * @return \StructType\CreateOrUpdatePaymentTermsResponse|bool
     */
    public function CreateOrUpdatePaymentTerms(\StructType\CreateOrUpdatePaymentTerms $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdatePaymentTerms($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CreateOrUpdateTaxCodes
     * Meta information extracted from the WSDL
     * - documentation: Create or update tax codes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreateOrUpdateTaxCodes $parameters
     * @return \StructType\CreateOrUpdateTaxCodesResponse|bool
     */
    public function CreateOrUpdateTaxCodes(\StructType\CreateOrUpdateTaxCodes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CreateOrUpdateTaxCodes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreateExtendedPayeeStatusFileResponse|\StructType\CreateOrUpdateCustomFieldsResponse|\StructType\CreateOrUpdateCustomFieldValueResponse|\StructType\CreateOrUpdateGLAccountsResponse|\StructType\CreateOrUpdateGrnsResponse|\StructType\CreateOrUpdateInvoicesResponse|\StructType\CreateOrUpdatePaymentTermsResponse|\StructType\CreateOrUpdatePurchaseOrdersResponse|\StructType\CreateOrUpdateTaxCodesResponse|\StructType\CreatePayeeStatusFileResponse|\StructType\CreatePaymentOrdersReportResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
