<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for WSErrors EnumType
 * @subpackage Enumerations
 */
class WSErrors extends AbstractStructEnumBase
{
    /**
     * Constant for value 'UnknownError'
     * @return string 'UnknownError'
     */
    const VALUE_UNKNOWN_ERROR = 'UnknownError';
    /**
     * Constant for value 'OK'
     * @return string 'OK'
     */
    const VALUE_OK = 'OK';
    /**
     * Constant for value 'UnknownCountryCode'
     * @return string 'UnknownCountryCode'
     */
    const VALUE_UNKNOWN_COUNTRY_CODE = 'UnknownCountryCode';
    /**
     * Constant for value 'CountryNotSupported'
     * @return string 'CountryNotSupported'
     */
    const VALUE_COUNTRY_NOT_SUPPORTED = 'CountryNotSupported';
    /**
     * Constant for value 'UnknownState'
     * @return string 'UnknownState'
     */
    const VALUE_UNKNOWN_STATE = 'UnknownState';
    /**
     * Constant for value 'PayerUnknown'
     * @return string 'PayerUnknown'
     */
    const VALUE_PAYER_UNKNOWN = 'PayerUnknown';
    /**
     * Constant for value 'PayeeUnknown'
     * @return string 'PayeeUnknown'
     */
    const VALUE_PAYEE_UNKNOWN = 'PayeeUnknown';
    /**
     * Constant for value 'EncryptionKeyFailedValidation'
     * @return string 'EncryptionKeyFailedValidation'
     */
    const VALUE_ENCRYPTION_KEY_FAILED_VALIDATION = 'EncryptionKeyFailedValidation';
    /**
     * Constant for value 'ParameterError'
     * @return string 'ParameterError'
     */
    const VALUE_PARAMETER_ERROR = 'ParameterError';
    /**
     * Constant for value 'FeeScheduleUnknown'
     * @return string 'FeeScheduleUnknown'
     */
    const VALUE_FEE_SCHEDULE_UNKNOWN = 'FeeScheduleUnknown';
    /**
     * Constant for value 'StringContainsNonEBCDICCharacters'
     * @return string 'StringContainsNonEBCDICCharacters'
     */
    const VALUE_STRING_CONTAINS_NON_EBCDICCHARACTERS = 'StringContainsNonEBCDICCharacters';
    /**
     * Constant for value 'PreferredEntityIsNotValid'
     * @return string 'PreferredEntityIsNotValid'
     */
    const VALUE_PREFERRED_ENTITY_IS_NOT_VALID = 'PreferredEntityIsNotValid';
    /**
     * Constant for value 'InvoiceRefCodeUnknown'
     * @return string 'InvoiceRefCodeUnknown'
     */
    const VALUE_INVOICE_REF_CODE_UNKNOWN = 'InvoiceRefCodeUnknown';
    /**
     * Constant for value 'InvoiceCannotBeCancelled'
     * @return string 'InvoiceCannotBeCancelled'
     */
    const VALUE_INVOICE_CANNOT_BE_CANCELLED = 'InvoiceCannotBeCancelled';
    /**
     * Constant for value 'UnknownCurrencyCode'
     * @return string 'UnknownCurrencyCode'
     */
    const VALUE_UNKNOWN_CURRENCY_CODE = 'UnknownCurrencyCode';
    /**
     * Constant for value 'InvalidJson'
     * @return string 'InvalidJson'
     */
    const VALUE_INVALID_JSON = 'InvalidJson';
    /**
     * Constant for value 'InvoiceValidationError'
     * @return string 'InvoiceValidationError'
     */
    const VALUE_INVOICE_VALIDATION_ERROR = 'InvoiceValidationError';
    /**
     * Constant for value 'ValidationError'
     * @return string 'ValidationError'
     */
    const VALUE_VALIDATION_ERROR = 'ValidationError';
    /**
     * Constant for value 'ValidationWarning'
     * @return string 'ValidationWarning'
     */
    const VALUE_VALIDATION_WARNING = 'ValidationWarning';
    /**
     * Constant for value 'BillsModuleMustBeEnabled'
     * @return string 'BillsModuleMustBeEnabled'
     */
    const VALUE_BILLS_MODULE_MUST_BE_ENABLED = 'BillsModuleMustBeEnabled';
    /**
     * Constant for value 'FileNotFound'
     * @return string 'FileNotFound'
     */
    const VALUE_FILE_NOT_FOUND = 'FileNotFound';
    /**
     * Constant for value 'InvoiceFileNotFound'
     * @return string 'InvoiceFileNotFound'
     */
    const VALUE_INVOICE_FILE_NOT_FOUND = 'InvoiceFileNotFound';
    /**
     * Constant for value 'CannotReadFile'
     * @return string 'CannotReadFile'
     */
    const VALUE_CANNOT_READ_FILE = 'CannotReadFile';
    /**
     * Constant for value 'CannotDeleteFile'
     * @return string 'CannotDeleteFile'
     */
    const VALUE_CANNOT_DELETE_FILE = 'CannotDeleteFile';
    /**
     * Constant for value 'CannotWriteFile'
     * @return string 'CannotWriteFile'
     */
    const VALUE_CANNOT_WRITE_FILE = 'CannotWriteFile';
    /**
     * Constant for value 'PaymentAmountTotalMismatch'
     * @return string 'PaymentAmountTotalMismatch'
     */
    const VALUE_PAYMENT_AMOUNT_TOTAL_MISMATCH = 'PaymentAmountTotalMismatch';
    /**
     * Constant for value 'InvalidPayerIpAddress'
     * @return string 'InvalidPayerIpAddress'
     */
    const VALUE_INVALID_PAYER_IP_ADDRESS = 'InvalidPayerIpAddress';
    /**
     * Constant for value 'EnahncedSecurityNotConfigured'
     * @return string 'EnahncedSecurityNotConfigured'
     */
    const VALUE_ENAHNCED_SECURITY_NOT_CONFIGURED = 'EnahncedSecurityNotConfigured';
    /**
     * Constant for value 'SubPayerIsNotFound'
     * @return string 'SubPayerIsNotFound'
     */
    const VALUE_SUB_PAYER_IS_NOT_FOUND = 'SubPayerIsNotFound';
    /**
     * Constant for value 'SubPayerDoensNotSupportDynamicKey'
     * @return string 'SubPayerDoensNotSupportDynamicKey'
     */
    const VALUE_SUB_PAYER_DOENS_NOT_SUPPORT_DYNAMIC_KEY = 'SubPayerDoensNotSupportDynamicKey';
    /**
     * Constant for value 'PayerDoesntSupportInvoiceModule'
     * @return string 'PayerDoesntSupportInvoiceModule'
     */
    const VALUE_PAYER_DOESNT_SUPPORT_INVOICE_MODULE = 'PayerDoesntSupportInvoiceModule';
    /**
     * Constant for value 'CustomFieldDoesNotExist'
     * @return string 'CustomFieldDoesNotExist'
     */
    const VALUE_CUSTOM_FIELD_DOES_NOT_EXIST = 'CustomFieldDoesNotExist';
    /**
     * Constant for value 'DuplicateInvoiceRefCode'
     * @return string 'DuplicateInvoiceRefCode'
     */
    const VALUE_DUPLICATE_INVOICE_REF_CODE = 'DuplicateInvoiceRefCode';
    /**
     * Constant for value 'PaidOrInProcessInvoiceCannotBeUpdated'
     * @return string 'PaidOrInProcessInvoiceCannotBeUpdated'
     */
    const VALUE_PAID_OR_IN_PROCESS_INVOICE_CANNOT_BE_UPDATED = 'PaidOrInProcessInvoiceCannotBeUpdated';
    /**
     * Constant for value 'CanApproveNotSupported'
     * @return string 'CanApproveNotSupported'
     */
    const VALUE_CAN_APPROVE_NOT_SUPPORTED = 'CanApproveNotSupported';
    /**
     * Constant for value 'AuthorizationError'
     * @return string 'AuthorizationError'
     */
    const VALUE_AUTHORIZATION_ERROR = 'AuthorizationError';
    /**
     * Constant for value 'InvoiceNotApprovedbyPayee'
     * @return string 'InvoiceNotApprovedbyPayee'
     */
    const VALUE_INVOICE_NOT_APPROVEDBY_PAYEE = 'InvoiceNotApprovedbyPayee';
    /**
     * Constant for value 'PaymentAmountCannotBeNegative'
     * @return string 'PaymentAmountCannotBeNegative'
     */
    const VALUE_PAYMENT_AMOUNT_CANNOT_BE_NEGATIVE = 'PaymentAmountCannotBeNegative';
    /**
     * Constant for value 'RequestLimitReached'
     * @return string 'RequestLimitReached'
     */
    const VALUE_REQUEST_LIMIT_REACHED = 'RequestLimitReached';
    /**
     * Constant for value 'ItemAlreadyInProcess'
     * @return string 'ItemAlreadyInProcess'
     */
    const VALUE_ITEM_ALREADY_IN_PROCESS = 'ItemAlreadyInProcess';
    /**
     * Constant for value 'RequestDoesNotExist'
     * @return string 'RequestDoesNotExist'
     */
    const VALUE_REQUEST_DOES_NOT_EXIST = 'RequestDoesNotExist';
    /**
     * Constant for value 'RequestStillInProgress'
     * @return string 'RequestStillInProgress'
     */
    const VALUE_REQUEST_STILL_IN_PROGRESS = 'RequestStillInProgress';
    /**
     * Constant for value 'CustomFieldValueIsNotUnique'
     * @return string 'CustomFieldValueIsNotUnique'
     */
    const VALUE_CUSTOM_FIELD_VALUE_IS_NOT_UNIQUE = 'CustomFieldValueIsNotUnique';
    /**
     * Constant for value 'BillStatusIsNotSupported'
     * @return string 'BillStatusIsNotSupported'
     */
    const VALUE_BILL_STATUS_IS_NOT_SUPPORTED = 'BillStatusIsNotSupported';
    /**
     * Constant for value 'GLAccountAssignedToActiveBill'
     * @return string 'GLAccountAssignedToActiveBill'
     */
    const VALUE_GLACCOUNT_ASSIGNED_TO_ACTIVE_BILL = 'GLAccountAssignedToActiveBill';
    /**
     * Constant for value 'CustomFieldValidationError'
     * @return string 'CustomFieldValidationError'
     */
    const VALUE_CUSTOM_FIELD_VALIDATION_ERROR = 'CustomFieldValidationError';
    /**
     * Constant for value 'CustomFieldValueValidationError'
     * @return string 'CustomFieldValueValidationError'
     */
    const VALUE_CUSTOM_FIELD_VALUE_VALIDATION_ERROR = 'CustomFieldValueValidationError';
    /**
     * Constant for value 'GlAccountValidationError'
     * @return string 'GlAccountValidationError'
     */
    const VALUE_GL_ACCOUNT_VALIDATION_ERROR = 'GlAccountValidationError';
    /**
     * Constant for value 'APAccountNotFound'
     * @return string 'APAccountNotFound'
     */
    const VALUE_APACCOUNT_NOT_FOUND = 'APAccountNotFound';
    /**
     * Constant for value 'SyncDirectionInvalid'
     * @return string 'SyncDirectionInvalid'
     */
    const VALUE_SYNC_DIRECTION_INVALID = 'SyncDirectionInvalid';
    /**
     * Constant for value 'ErrorTypeInvalid'
     * @return string 'ErrorTypeInvalid'
     */
    const VALUE_ERROR_TYPE_INVALID = 'ErrorTypeInvalid';
    /**
     * Constant for value 'IntegrationNameInvalid'
     * @return string 'IntegrationNameInvalid'
     */
    const VALUE_INTEGRATION_NAME_INVALID = 'IntegrationNameInvalid';
    /**
     * Constant for value 'IntegrationVersionOverMaxLength'
     * @return string 'IntegrationVersionOverMaxLength'
     */
    const VALUE_INTEGRATION_VERSION_OVER_MAX_LENGTH = 'IntegrationVersionOverMaxLength';
    /**
     * Constant for value 'CreationTimestampInvalid'
     * @return string 'CreationTimestampInvalid'
     */
    const VALUE_CREATION_TIMESTAMP_INVALID = 'CreationTimestampInvalid';
    /**
     * Constant for value 'ErrorDetailsInvalid'
     * @return string 'ErrorDetailsInvalid'
     */
    const VALUE_ERROR_DETAILS_INVALID = 'ErrorDetailsInvalid';
    /**
     * Constant for value 'PaymentTermNotFound'
     * @return string 'PaymentTermNotFound'
     */
    const VALUE_PAYMENT_TERM_NOT_FOUND = 'PaymentTermNotFound';
    /**
     * Constant for value 'CustomFieldInvalidDateFormat'
     * @return string 'CustomFieldInvalidDateFormat'
     */
    const VALUE_CUSTOM_FIELD_INVALID_DATE_FORMAT = 'CustomFieldInvalidDateFormat';
    /**
     * Constant for value 'PaymentTermValidationError'
     * @return string 'PaymentTermValidationError'
     */
    const VALUE_PAYMENT_TERM_VALIDATION_ERROR = 'PaymentTermValidationError';
    /**
     * Constant for value 'TaxCodeValidationError'
     * @return string 'TaxCodeValidationError'
     */
    const VALUE_TAX_CODE_VALIDATION_ERROR = 'TaxCodeValidationError';
    /**
     * Constant for value 'TaxCodeExternalIdNotFoundError'
     * @return string 'TaxCodeExternalIdNotFoundError'
     */
    const VALUE_TAX_CODE_EXTERNAL_ID_NOT_FOUND_ERROR = 'TaxCodeExternalIdNotFoundError';
    /**
     * Constant for value 'IllegalErpCurrencyUpdate'
     * @return string 'IllegalErpCurrencyUpdate'
     */
    const VALUE_ILLEGAL_ERP_CURRENCY_UPDATE = 'IllegalErpCurrencyUpdate';
    /**
     * Constant for value 'PurchaseOrderNotFound'
     * @return string 'PurchaseOrderNotFound'
     */
    const VALUE_PURCHASE_ORDER_NOT_FOUND = 'PurchaseOrderNotFound';
    /**
     * Constant for value 'GoodsReceivedNotificationNotFound'
     * @return string 'GoodsReceivedNotificationNotFound'
     */
    const VALUE_GOODS_RECEIVED_NOTIFICATION_NOT_FOUND = 'GoodsReceivedNotificationNotFound';
    /**
     * Constant for value 'PayeeAlreadyInvited'
     * @return string 'PayeeAlreadyInvited'
     */
    const VALUE_PAYEE_ALREADY_INVITED = 'PayeeAlreadyInvited';
    /**
     * Constant for value 'MissingEmail'
     * @return string 'MissingEmail'
     */
    const VALUE_MISSING_EMAIL = 'MissingEmail';
    /**
     * Constant for value 'PayeeAlreadyRegistered'
     * @return string 'PayeeAlreadyRegistered'
     */
    const VALUE_PAYEE_ALREADY_REGISTERED = 'PayeeAlreadyRegistered';
    /**
     * Constant for value 'PayeeEmailNotUnique'
     * @return string 'PayeeEmailNotUnique'
     */
    const VALUE_PAYEE_EMAIL_NOT_UNIQUE = 'PayeeEmailNotUnique';
    /**
     * Constant for value 'SupplierPortalDisabled'
     * @return string 'SupplierPortalDisabled'
     */
    const VALUE_SUPPLIER_PORTAL_DISABLED = 'SupplierPortalDisabled';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN_ERROR
     * @uses self::VALUE_OK
     * @uses self::VALUE_UNKNOWN_COUNTRY_CODE
     * @uses self::VALUE_COUNTRY_NOT_SUPPORTED
     * @uses self::VALUE_UNKNOWN_STATE
     * @uses self::VALUE_PAYER_UNKNOWN
     * @uses self::VALUE_PAYEE_UNKNOWN
     * @uses self::VALUE_ENCRYPTION_KEY_FAILED_VALIDATION
     * @uses self::VALUE_PARAMETER_ERROR
     * @uses self::VALUE_FEE_SCHEDULE_UNKNOWN
     * @uses self::VALUE_STRING_CONTAINS_NON_EBCDICCHARACTERS
     * @uses self::VALUE_PREFERRED_ENTITY_IS_NOT_VALID
     * @uses self::VALUE_INVOICE_REF_CODE_UNKNOWN
     * @uses self::VALUE_INVOICE_CANNOT_BE_CANCELLED
     * @uses self::VALUE_UNKNOWN_CURRENCY_CODE
     * @uses self::VALUE_INVALID_JSON
     * @uses self::VALUE_INVOICE_VALIDATION_ERROR
     * @uses self::VALUE_VALIDATION_ERROR
     * @uses self::VALUE_VALIDATION_WARNING
     * @uses self::VALUE_BILLS_MODULE_MUST_BE_ENABLED
     * @uses self::VALUE_FILE_NOT_FOUND
     * @uses self::VALUE_INVOICE_FILE_NOT_FOUND
     * @uses self::VALUE_CANNOT_READ_FILE
     * @uses self::VALUE_CANNOT_DELETE_FILE
     * @uses self::VALUE_CANNOT_WRITE_FILE
     * @uses self::VALUE_PAYMENT_AMOUNT_TOTAL_MISMATCH
     * @uses self::VALUE_INVALID_PAYER_IP_ADDRESS
     * @uses self::VALUE_ENAHNCED_SECURITY_NOT_CONFIGURED
     * @uses self::VALUE_SUB_PAYER_IS_NOT_FOUND
     * @uses self::VALUE_SUB_PAYER_DOENS_NOT_SUPPORT_DYNAMIC_KEY
     * @uses self::VALUE_PAYER_DOESNT_SUPPORT_INVOICE_MODULE
     * @uses self::VALUE_CUSTOM_FIELD_DOES_NOT_EXIST
     * @uses self::VALUE_DUPLICATE_INVOICE_REF_CODE
     * @uses self::VALUE_PAID_OR_IN_PROCESS_INVOICE_CANNOT_BE_UPDATED
     * @uses self::VALUE_CAN_APPROVE_NOT_SUPPORTED
     * @uses self::VALUE_AUTHORIZATION_ERROR
     * @uses self::VALUE_INVOICE_NOT_APPROVEDBY_PAYEE
     * @uses self::VALUE_PAYMENT_AMOUNT_CANNOT_BE_NEGATIVE
     * @uses self::VALUE_REQUEST_LIMIT_REACHED
     * @uses self::VALUE_ITEM_ALREADY_IN_PROCESS
     * @uses self::VALUE_REQUEST_DOES_NOT_EXIST
     * @uses self::VALUE_REQUEST_STILL_IN_PROGRESS
     * @uses self::VALUE_CUSTOM_FIELD_VALUE_IS_NOT_UNIQUE
     * @uses self::VALUE_BILL_STATUS_IS_NOT_SUPPORTED
     * @uses self::VALUE_GLACCOUNT_ASSIGNED_TO_ACTIVE_BILL
     * @uses self::VALUE_CUSTOM_FIELD_VALIDATION_ERROR
     * @uses self::VALUE_CUSTOM_FIELD_VALUE_VALIDATION_ERROR
     * @uses self::VALUE_GL_ACCOUNT_VALIDATION_ERROR
     * @uses self::VALUE_APACCOUNT_NOT_FOUND
     * @uses self::VALUE_SYNC_DIRECTION_INVALID
     * @uses self::VALUE_ERROR_TYPE_INVALID
     * @uses self::VALUE_INTEGRATION_NAME_INVALID
     * @uses self::VALUE_INTEGRATION_VERSION_OVER_MAX_LENGTH
     * @uses self::VALUE_CREATION_TIMESTAMP_INVALID
     * @uses self::VALUE_ERROR_DETAILS_INVALID
     * @uses self::VALUE_PAYMENT_TERM_NOT_FOUND
     * @uses self::VALUE_CUSTOM_FIELD_INVALID_DATE_FORMAT
     * @uses self::VALUE_PAYMENT_TERM_VALIDATION_ERROR
     * @uses self::VALUE_TAX_CODE_VALIDATION_ERROR
     * @uses self::VALUE_TAX_CODE_EXTERNAL_ID_NOT_FOUND_ERROR
     * @uses self::VALUE_ILLEGAL_ERP_CURRENCY_UPDATE
     * @uses self::VALUE_PURCHASE_ORDER_NOT_FOUND
     * @uses self::VALUE_GOODS_RECEIVED_NOTIFICATION_NOT_FOUND
     * @uses self::VALUE_PAYEE_ALREADY_INVITED
     * @uses self::VALUE_MISSING_EMAIL
     * @uses self::VALUE_PAYEE_ALREADY_REGISTERED
     * @uses self::VALUE_PAYEE_EMAIL_NOT_UNIQUE
     * @uses self::VALUE_SUPPLIER_PORTAL_DISABLED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN_ERROR,
            self::VALUE_OK,
            self::VALUE_UNKNOWN_COUNTRY_CODE,
            self::VALUE_COUNTRY_NOT_SUPPORTED,
            self::VALUE_UNKNOWN_STATE,
            self::VALUE_PAYER_UNKNOWN,
            self::VALUE_PAYEE_UNKNOWN,
            self::VALUE_ENCRYPTION_KEY_FAILED_VALIDATION,
            self::VALUE_PARAMETER_ERROR,
            self::VALUE_FEE_SCHEDULE_UNKNOWN,
            self::VALUE_STRING_CONTAINS_NON_EBCDICCHARACTERS,
            self::VALUE_PREFERRED_ENTITY_IS_NOT_VALID,
            self::VALUE_INVOICE_REF_CODE_UNKNOWN,
            self::VALUE_INVOICE_CANNOT_BE_CANCELLED,
            self::VALUE_UNKNOWN_CURRENCY_CODE,
            self::VALUE_INVALID_JSON,
            self::VALUE_INVOICE_VALIDATION_ERROR,
            self::VALUE_VALIDATION_ERROR,
            self::VALUE_VALIDATION_WARNING,
            self::VALUE_BILLS_MODULE_MUST_BE_ENABLED,
            self::VALUE_FILE_NOT_FOUND,
            self::VALUE_INVOICE_FILE_NOT_FOUND,
            self::VALUE_CANNOT_READ_FILE,
            self::VALUE_CANNOT_DELETE_FILE,
            self::VALUE_CANNOT_WRITE_FILE,
            self::VALUE_PAYMENT_AMOUNT_TOTAL_MISMATCH,
            self::VALUE_INVALID_PAYER_IP_ADDRESS,
            self::VALUE_ENAHNCED_SECURITY_NOT_CONFIGURED,
            self::VALUE_SUB_PAYER_IS_NOT_FOUND,
            self::VALUE_SUB_PAYER_DOENS_NOT_SUPPORT_DYNAMIC_KEY,
            self::VALUE_PAYER_DOESNT_SUPPORT_INVOICE_MODULE,
            self::VALUE_CUSTOM_FIELD_DOES_NOT_EXIST,
            self::VALUE_DUPLICATE_INVOICE_REF_CODE,
            self::VALUE_PAID_OR_IN_PROCESS_INVOICE_CANNOT_BE_UPDATED,
            self::VALUE_CAN_APPROVE_NOT_SUPPORTED,
            self::VALUE_AUTHORIZATION_ERROR,
            self::VALUE_INVOICE_NOT_APPROVEDBY_PAYEE,
            self::VALUE_PAYMENT_AMOUNT_CANNOT_BE_NEGATIVE,
            self::VALUE_REQUEST_LIMIT_REACHED,
            self::VALUE_ITEM_ALREADY_IN_PROCESS,
            self::VALUE_REQUEST_DOES_NOT_EXIST,
            self::VALUE_REQUEST_STILL_IN_PROGRESS,
            self::VALUE_CUSTOM_FIELD_VALUE_IS_NOT_UNIQUE,
            self::VALUE_BILL_STATUS_IS_NOT_SUPPORTED,
            self::VALUE_GLACCOUNT_ASSIGNED_TO_ACTIVE_BILL,
            self::VALUE_CUSTOM_FIELD_VALIDATION_ERROR,
            self::VALUE_CUSTOM_FIELD_VALUE_VALIDATION_ERROR,
            self::VALUE_GL_ACCOUNT_VALIDATION_ERROR,
            self::VALUE_APACCOUNT_NOT_FOUND,
            self::VALUE_SYNC_DIRECTION_INVALID,
            self::VALUE_ERROR_TYPE_INVALID,
            self::VALUE_INTEGRATION_NAME_INVALID,
            self::VALUE_INTEGRATION_VERSION_OVER_MAX_LENGTH,
            self::VALUE_CREATION_TIMESTAMP_INVALID,
            self::VALUE_ERROR_DETAILS_INVALID,
            self::VALUE_PAYMENT_TERM_NOT_FOUND,
            self::VALUE_CUSTOM_FIELD_INVALID_DATE_FORMAT,
            self::VALUE_PAYMENT_TERM_VALIDATION_ERROR,
            self::VALUE_TAX_CODE_VALIDATION_ERROR,
            self::VALUE_TAX_CODE_EXTERNAL_ID_NOT_FOUND_ERROR,
            self::VALUE_ILLEGAL_ERP_CURRENCY_UPDATE,
            self::VALUE_PURCHASE_ORDER_NOT_FOUND,
            self::VALUE_GOODS_RECEIVED_NOTIFICATION_NOT_FOUND,
            self::VALUE_PAYEE_ALREADY_INVITED,
            self::VALUE_MISSING_EMAIL,
            self::VALUE_PAYEE_ALREADY_REGISTERED,
            self::VALUE_PAYEE_EMAIL_NOT_UNIQUE,
            self::VALUE_SUPPLIER_PORTAL_DISABLED,
        );
    }
}
