<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TipaltiInvoiceStatus EnumType
 * @subpackage Enumerations
 */
class TipaltiInvoiceStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'PendingApReview'
     * @return string 'PendingApReview'
     */
    const VALUE_PENDING_AP_REVIEW = 'PendingApReview';
    /**
     * Constant for value 'PendingApproval'
     * @return string 'PendingApproval'
     */
    const VALUE_PENDING_APPROVAL = 'PendingApproval';
    /**
     * Constant for value 'PendingApAction'
     * @return string 'PendingApAction'
     */
    const VALUE_PENDING_AP_ACTION = 'PendingApAction';
    /**
     * Constant for value 'PendingPayment'
     * @return string 'PendingPayment'
     */
    const VALUE_PENDING_PAYMENT = 'PendingPayment';
    /**
     * Constant for value 'SubmittedForPayment'
     * @return string 'SubmittedForPayment'
     */
    const VALUE_SUBMITTED_FOR_PAYMENT = 'SubmittedForPayment';
    /**
     * Constant for value 'Paid'
     * @return string 'Paid'
     */
    const VALUE_PAID = 'Paid';
    /**
     * Constant for value 'Disputed'
     * @return string 'Disputed'
     */
    const VALUE_DISPUTED = 'Disputed';
    /**
     * Constant for value 'Deleted'
     * @return string 'Deleted'
     */
    const VALUE_DELETED = 'Deleted';
    /**
     * Constant for value 'PendingPayeeApproval'
     * @return string 'PendingPayeeApproval'
     */
    const VALUE_PENDING_PAYEE_APPROVAL = 'PendingPayeeApproval';
    /**
     * Constant for value 'PendingPayeeInvoice'
     * @return string 'PendingPayeeInvoice'
     */
    const VALUE_PENDING_PAYEE_INVOICE = 'PendingPayeeInvoice';
    /**
     * Constant for value 'PartiallyPaid'
     * @return string 'PartiallyPaid'
     */
    const VALUE_PARTIALLY_PAID = 'PartiallyPaid';
    /**
     * Constant for value 'ScheduledForPayment'
     * @return string 'ScheduledForPayment'
     */
    const VALUE_SCHEDULED_FOR_PAYMENT = 'ScheduledForPayment';
    /**
     * Constant for value 'ReviewMatching'
     * @return string 'ReviewMatching'
     */
    const VALUE_REVIEW_MATCHING = 'ReviewMatching';
    /**
     * Constant for value 'PendingMatching'
     * @return string 'PendingMatching'
     */
    const VALUE_PENDING_MATCHING = 'PendingMatching';
    /**
     * Return allowed values
     * @uses self::VALUE_PENDING_AP_REVIEW
     * @uses self::VALUE_PENDING_APPROVAL
     * @uses self::VALUE_PENDING_AP_ACTION
     * @uses self::VALUE_PENDING_PAYMENT
     * @uses self::VALUE_SUBMITTED_FOR_PAYMENT
     * @uses self::VALUE_PAID
     * @uses self::VALUE_DISPUTED
     * @uses self::VALUE_DELETED
     * @uses self::VALUE_PENDING_PAYEE_APPROVAL
     * @uses self::VALUE_PENDING_PAYEE_INVOICE
     * @uses self::VALUE_PARTIALLY_PAID
     * @uses self::VALUE_SCHEDULED_FOR_PAYMENT
     * @uses self::VALUE_REVIEW_MATCHING
     * @uses self::VALUE_PENDING_MATCHING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PENDING_AP_REVIEW,
            self::VALUE_PENDING_APPROVAL,
            self::VALUE_PENDING_AP_ACTION,
            self::VALUE_PENDING_PAYMENT,
            self::VALUE_SUBMITTED_FOR_PAYMENT,
            self::VALUE_PAID,
            self::VALUE_DISPUTED,
            self::VALUE_DELETED,
            self::VALUE_PENDING_PAYEE_APPROVAL,
            self::VALUE_PENDING_PAYEE_INVOICE,
            self::VALUE_PARTIALLY_PAID,
            self::VALUE_SCHEDULED_FOR_PAYMENT,
            self::VALUE_REVIEW_MATCHING,
            self::VALUE_PENDING_MATCHING,
        );
    }
}
