<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRelatedInvoice ArrayType
 * @subpackage Arrays
 */
class ArrayOfRelatedInvoice extends AbstractStructArrayBase
{
    /**
     * The RelatedInvoice
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\RelatedInvoice[]
     */
    public $RelatedInvoice;
    /**
     * Constructor method for ArrayOfRelatedInvoice
     * @uses ArrayOfRelatedInvoice::setRelatedInvoice()
     * @param \StructType\RelatedInvoice[] $relatedInvoice
     */
    public function __construct(array $relatedInvoice = array())
    {
        $this
            ->setRelatedInvoice($relatedInvoice);
    }
    /**
     * Get RelatedInvoice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\RelatedInvoice[]|null
     */
    public function getRelatedInvoice()
    {
        return isset($this->RelatedInvoice) ? $this->RelatedInvoice : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedInvoice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedInvoice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedInvoiceForArrayConstraintsFromSetRelatedInvoice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRelatedInvoiceRelatedInvoiceItem) {
            // validation for constraint: itemType
            if (!$arrayOfRelatedInvoiceRelatedInvoiceItem instanceof \StructType\RelatedInvoice) {
                $invalidValues[] = is_object($arrayOfRelatedInvoiceRelatedInvoiceItem) ? get_class($arrayOfRelatedInvoiceRelatedInvoiceItem) : sprintf('%s(%s)', gettype($arrayOfRelatedInvoiceRelatedInvoiceItem), var_export($arrayOfRelatedInvoiceRelatedInvoiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedInvoice property can only contain items of type \StructType\RelatedInvoice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedInvoice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedInvoice[] $relatedInvoice
     * @return \ArrayType\ArrayOfRelatedInvoice
     */
    public function setRelatedInvoice(array $relatedInvoice = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedInvoiceArrayErrorMessage = self::validateRelatedInvoiceForArrayConstraintsFromSetRelatedInvoice($relatedInvoice))) {
            throw new \InvalidArgumentException($relatedInvoiceArrayErrorMessage, __LINE__);
        }
        if (is_null($relatedInvoice) || (is_array($relatedInvoice) && empty($relatedInvoice))) {
            unset($this->RelatedInvoice);
        } else {
            $this->RelatedInvoice = $relatedInvoice;
        }
        return $this;
    }
    /**
     * Add item to RelatedInvoice value
     * @throws \InvalidArgumentException
     * @param \StructType\RelatedInvoice $item
     * @return \ArrayType\ArrayOfRelatedInvoice
     */
    public function addToRelatedInvoice(\StructType\RelatedInvoice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RelatedInvoice) {
            throw new \InvalidArgumentException(sprintf('The RelatedInvoice property can only contain items of type \StructType\RelatedInvoice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedInvoice[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\RelatedInvoice|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\RelatedInvoice|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\RelatedInvoice|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\RelatedInvoice|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\RelatedInvoice|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RelatedInvoice
     */
    public function getAttributeName()
    {
        return 'RelatedInvoice';
    }
}
