<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPayerEntityInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfPayerEntityInfo extends AbstractStructArrayBase
{
    /**
     * The PayerEntityInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PayerEntityInfo[]
     */
    public $PayerEntityInfo;
    /**
     * Constructor method for ArrayOfPayerEntityInfo
     * @uses ArrayOfPayerEntityInfo::setPayerEntityInfo()
     * @param \StructType\PayerEntityInfo[] $payerEntityInfo
     */
    public function __construct(array $payerEntityInfo = array())
    {
        $this
            ->setPayerEntityInfo($payerEntityInfo);
    }
    /**
     * Get PayerEntityInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PayerEntityInfo[]|null
     */
    public function getPayerEntityInfo()
    {
        return isset($this->PayerEntityInfo) ? $this->PayerEntityInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setPayerEntityInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPayerEntityInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePayerEntityInfoForArrayConstraintsFromSetPayerEntityInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPayerEntityInfoPayerEntityInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfPayerEntityInfoPayerEntityInfoItem instanceof \StructType\PayerEntityInfo) {
                $invalidValues[] = is_object($arrayOfPayerEntityInfoPayerEntityInfoItem) ? get_class($arrayOfPayerEntityInfoPayerEntityInfoItem) : sprintf('%s(%s)', gettype($arrayOfPayerEntityInfoPayerEntityInfoItem), var_export($arrayOfPayerEntityInfoPayerEntityInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PayerEntityInfo property can only contain items of type \StructType\PayerEntityInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PayerEntityInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PayerEntityInfo[] $payerEntityInfo
     * @return \ArrayType\ArrayOfPayerEntityInfo
     */
    public function setPayerEntityInfo(array $payerEntityInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($payerEntityInfoArrayErrorMessage = self::validatePayerEntityInfoForArrayConstraintsFromSetPayerEntityInfo($payerEntityInfo))) {
            throw new \InvalidArgumentException($payerEntityInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($payerEntityInfo) || (is_array($payerEntityInfo) && empty($payerEntityInfo))) {
            unset($this->PayerEntityInfo);
        } else {
            $this->PayerEntityInfo = $payerEntityInfo;
        }
        return $this;
    }
    /**
     * Add item to PayerEntityInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\PayerEntityInfo $item
     * @return \ArrayType\ArrayOfPayerEntityInfo
     */
    public function addToPayerEntityInfo(\StructType\PayerEntityInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PayerEntityInfo) {
            throw new \InvalidArgumentException(sprintf('The PayerEntityInfo property can only contain items of type \StructType\PayerEntityInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PayerEntityInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PayerEntityInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PayerEntityInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PayerEntityInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PayerEntityInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PayerEntityInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PayerEntityInfo
     */
    public function getAttributeName()
    {
        return 'PayerEntityInfo';
    }
}
