<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceFault DTO
 * Meta informations extracted from the WSDL
 * - type: tns:ServiceFault
 * @subpackage Structs
 */
class ServiceFault extends AbstractStructBase
{
    /**
     * The exceptionClass
     * @var string
     */
    public $exceptionClass;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The message
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $message;
    /**
     * Constructor method for ServiceFault
     * @uses ServiceFault::setExceptionClass()
     * @uses ServiceFault::setCode()
     * @uses ServiceFault::setMessage()
     * @param string $exceptionClass
     * @param string $code
     * @param string $message
     */
    public function __construct($exceptionClass = null, $code = null, $message = null)
    {
        $this
            ->setExceptionClass($exceptionClass)
            ->setCode($code)
            ->setMessage($message);
    }
    /**
     * Get exceptionClass value
     * @return string|null
     */
    public function getExceptionClass()
    {
        return $this->exceptionClass;
    }
    /**
     * Set exceptionClass value
     * @param string $exceptionClass
     * @return \AppBundle/Soap/Play\DTO\ServiceFault
     */
    public function setExceptionClass($exceptionClass = null)
    {
        // validation for constraint: string
        if (!is_null($exceptionClass) && !is_string($exceptionClass)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($exceptionClass)), __LINE__);
        }
        $this->exceptionClass = $exceptionClass;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \AppBundle/Soap/Play\DTO\ServiceFault
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->message;
    }
    /**
     * Set message value
     * @param string $message
     * @return \AppBundle/Soap/Play\DTO\ServiceFault
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($message)), __LINE__);
        }
        $this->message = $message;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\ServiceFault
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
