<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fileType DTO
 * @subpackage Structs
 */
class FileType extends AbstractStructBase
{
    /**
     * The fileName
     * @var string
     */
    public $fileName;
    /**
     * The fileData
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \AppBundle/Soap/Play\DTO\FileData
     */
    public $fileData;
    /**
     * The relativePath
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $relativePath;
    /**
     * Constructor method for fileType
     * @uses FileType::setFileName()
     * @uses FileType::setFileData()
     * @uses FileType::setRelativePath()
     * @param string $fileName
     * @param \AppBundle/Soap/Play\DTO\FileData $fileData
     * @param string $relativePath
     */
    public function __construct($fileName = null, \AppBundle/Soap/Play\DTO\FileData $fileData = null, $relativePath = null)
    {
        $this
            ->setFileName($fileName)
            ->setFileData($fileData)
            ->setRelativePath($relativePath);
    }
    /**
     * Get fileName value
     * @return string|null
     */
    public function getFileName()
    {
        return $this->fileName;
    }
    /**
     * Set fileName value
     * @param string $fileName
     * @return \AppBundle/Soap/Play\DTO\FileType
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fileName)), __LINE__);
        }
        $this->fileName = $fileName;
        return $this;
    }
    /**
     * Get fileData value
     * @return \AppBundle/Soap/Play\DTO\FileData|null
     */
    public function getFileData()
    {
        return $this->fileData;
    }
    /**
     * Set fileData value
     * @param \AppBundle/Soap/Play\DTO\FileData $fileData
     * @return \AppBundle/Soap/Play\DTO\FileType
     */
    public function setFileData(\AppBundle/Soap/Play\DTO\FileData $fileData = null)
    {
        $this->fileData = $fileData;
        return $this;
    }
    /**
     * Get relativePath value
     * @return string|null
     */
    public function getRelativePath()
    {
        return $this->relativePath;
    }
    /**
     * Set relativePath value
     * @param string $relativePath
     * @return \AppBundle/Soap/Play\DTO\FileType
     */
    public function setRelativePath($relativePath = null)
    {
        // validation for constraint: string
        if (!is_null($relativePath) && !is_string($relativePath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($relativePath)), __LINE__);
        }
        $this->relativePath = $relativePath;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\FileType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
