<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fileData DTO
 * @subpackage Structs
 */
class FileData extends AbstractStructBase
{
    /**
     * The content
     * Meta informations extracted from the WSDL
     * - ref: ns1:content
     * @var string
     */
    public $content;
    /**
     * Constructor method for fileData
     * @uses FileData::setContent()
     * @param string $content
     */
    public function __construct($content = null)
    {
        $this
            ->setContent($content);
    }
    /**
     * Get content value
     * @return string|null
     */
    public function getContent()
    {
        return $this->content;
    }
    /**
     * Set content value
     * @param string $content
     * @return \AppBundle/Soap/Play\DTO\FileData
     */
    public function setContent($content = null)
    {
        // validation for constraint: string
        if (!is_null($content) && !is_string($content)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($content)), __LINE__);
        }
        $this->content = $content;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\FileData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
