<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for parameterType DTO
 * @subpackage Structs
 */
class ParameterType extends AbstractStructBase
{
    /**
     * The paramName
     * @var string
     */
    public $paramName;
    /**
     * The paramValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $paramValue;
    /**
     * Constructor method for parameterType
     * @uses ParameterType::setParamName()
     * @uses ParameterType::setParamValue()
     * @param string $paramName
     * @param string $paramValue
     */
    public function __construct($paramName = null, $paramValue = null)
    {
        $this
            ->setParamName($paramName)
            ->setParamValue($paramValue);
    }
    /**
     * Get paramName value
     * @return string|null
     */
    public function getParamName()
    {
        return $this->paramName;
    }
    /**
     * Set paramName value
     * @param string $paramName
     * @return \AppBundle/Soap/Play\DTO\ParameterType
     */
    public function setParamName($paramName = null)
    {
        // validation for constraint: string
        if (!is_null($paramName) && !is_string($paramName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramName)), __LINE__);
        }
        $this->paramName = $paramName;
        return $this;
    }
    /**
     * Get paramValue value
     * @return string|null
     */
    public function getParamValue()
    {
        return $this->paramValue;
    }
    /**
     * Set paramValue value
     * @param string $paramValue
     * @return \AppBundle/Soap/Play\DTO\ParameterType
     */
    public function setParamValue($paramValue = null)
    {
        // validation for constraint: string
        if (!is_null($paramValue) && !is_string($paramValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paramValue)), __LINE__);
        }
        $this->paramValue = $paramValue;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\ParameterType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
