<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eventsType DTO
 * @subpackage Structs
 */
class EventsType extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The systemName
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $systemName;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $createDate;
    /**
     * The event
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \AppBundle/Soap/Play\DTO\EventType[]
     */
    public $event;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * Constructor method for eventsType
     * @uses EventsType::setId()
     * @uses EventsType::setSystemName()
     * @uses EventsType::setCreateDate()
     * @uses EventsType::setEvent()
     * @uses EventsType::setType()
     * @param string $id
     * @param string $systemName
     * @param string $createDate
     * @param \AppBundle/Soap/Play\DTO\EventType[] $event
     * @param string $type
     */
    public function __construct($id = null, $systemName = null, $createDate = null, array $event = array(), $type = null)
    {
        $this
            ->setId($id)
            ->setSystemName($systemName)
            ->setCreateDate($createDate)
            ->setEvent($event)
            ->setType($type);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get systemName value
     * @return string
     */
    public function getSystemName()
    {
        return $this->systemName;
    }
    /**
     * Set systemName value
     * @param string $systemName
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function setSystemName($systemName = null)
    {
        // validation for constraint: string
        if (!is_null($systemName) && !is_string($systemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($systemName)), __LINE__);
        }
        $this->systemName = $systemName;
        return $this;
    }
    /**
     * Get createDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get event value
     * @return \AppBundle/Soap/Play\DTO\EventType[]|null
     */
    public function getEvent()
    {
        return $this->event;
    }
    /**
     * Set event value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\EventType[] $event
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function setEvent(array $event = array())
    {
        foreach ($event as $eventsTypeEventItem) {
            // validation for constraint: itemType
            if (!$eventsTypeEventItem instanceof \AppBundle/Soap/Play\DTO\EventType) {
                throw new \InvalidArgumentException(sprintf('The event property can only contain items of \AppBundle/Soap/Play\DTO\EventType, "%s" given', is_object($eventsTypeEventItem) ? get_class($eventsTypeEventItem) : gettype($eventsTypeEventItem)), __LINE__);
            }
        }
        $this->event = $event;
        return $this;
    }
    /**
     * Add item to event value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\EventType $item
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function addToEvent(\AppBundle/Soap/Play\DTO\EventType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AppBundle/Soap/Play\DTO\EventType) {
            throw new \InvalidArgumentException(sprintf('The event property can only contain items of \AppBundle/Soap/Play\DTO\EventType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->event[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\EventsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
