<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for eventType DTO
 * @subpackage Structs
 */
class EventType extends AbstractStructBase
{
    /**
     * The eventId
     * @var string
     */
    public $eventId;
    /**
     * The eventDate
     * @var string
     */
    public $eventDate;
    /**
     * The eventType
     * @var string
     */
    public $eventType;
    /**
     * The eventParam
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AppBundle/Soap/Play\DTO\ParameterType[]
     */
    public $eventParam;
    /**
     * The file
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \AppBundle/Soap/Play\DTO\FileType[]
     */
    public $file;
    /**
     * Constructor method for eventType
     * @uses EventType::setEventId()
     * @uses EventType::setEventDate()
     * @uses EventType::setEventType()
     * @uses EventType::setEventParam()
     * @uses EventType::setFile()
     * @param string $eventId
     * @param string $eventDate
     * @param string $eventType
     * @param \AppBundle/Soap/Play\DTO\ParameterType[] $eventParam
     * @param \AppBundle/Soap/Play\DTO\FileType[] $file
     */
    public function __construct($eventId = null, $eventDate = null, $eventType = null, array $eventParam = array(), array $file = array())
    {
        $this
            ->setEventId($eventId)
            ->setEventDate($eventDate)
            ->setEventType($eventType)
            ->setEventParam($eventParam)
            ->setFile($file);
    }
    /**
     * Get eventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->eventId;
    }
    /**
     * Set eventId value
     * @param string $eventId
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventId)), __LINE__);
        }
        $this->eventId = $eventId;
        return $this;
    }
    /**
     * Get eventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->eventDate;
    }
    /**
     * Set eventDate value
     * @param string $eventDate
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventDate)), __LINE__);
        }
        $this->eventDate = $eventDate;
        return $this;
    }
    /**
     * Get eventType value
     * @return string|null
     */
    public function getEventType()
    {
        return $this->eventType;
    }
    /**
     * Set eventType value
     * @param string $eventType
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function setEventType($eventType = null)
    {
        // validation for constraint: string
        if (!is_null($eventType) && !is_string($eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eventType)), __LINE__);
        }
        $this->eventType = $eventType;
        return $this;
    }
    /**
     * Get eventParam value
     * @return \AppBundle/Soap/Play\DTO\ParameterType[]|null
     */
    public function getEventParam()
    {
        return $this->eventParam;
    }
    /**
     * Set eventParam value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\ParameterType[] $eventParam
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function setEventParam(array $eventParam = array())
    {
        foreach ($eventParam as $eventTypeEventParamItem) {
            // validation for constraint: itemType
            if (!$eventTypeEventParamItem instanceof \AppBundle/Soap/Play\DTO\ParameterType) {
                throw new \InvalidArgumentException(sprintf('The eventParam property can only contain items of \AppBundle/Soap/Play\DTO\ParameterType, "%s" given', is_object($eventTypeEventParamItem) ? get_class($eventTypeEventParamItem) : gettype($eventTypeEventParamItem)), __LINE__);
            }
        }
        $this->eventParam = $eventParam;
        return $this;
    }
    /**
     * Add item to eventParam value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\ParameterType $item
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function addToEventParam(\AppBundle/Soap/Play\DTO\ParameterType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AppBundle/Soap/Play\DTO\ParameterType) {
            throw new \InvalidArgumentException(sprintf('The eventParam property can only contain items of \AppBundle/Soap/Play\DTO\ParameterType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->eventParam[] = $item;
        return $this;
    }
    /**
     * Get file value
     * @return \AppBundle/Soap/Play\DTO\FileType[]|null
     */
    public function getFile()
    {
        return $this->file;
    }
    /**
     * Set file value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\FileType[] $file
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function setFile(array $file = array())
    {
        foreach ($file as $eventTypeFileItem) {
            // validation for constraint: itemType
            if (!$eventTypeFileItem instanceof \AppBundle/Soap/Play\DTO\FileType) {
                throw new \InvalidArgumentException(sprintf('The file property can only contain items of \AppBundle/Soap/Play\DTO\FileType, "%s" given', is_object($eventTypeFileItem) ? get_class($eventTypeFileItem) : gettype($eventTypeFileItem)), __LINE__);
            }
        }
        $this->file = $file;
        return $this;
    }
    /**
     * Add item to file value
     * @throws \InvalidArgumentException
     * @param \AppBundle/Soap/Play\DTO\FileType $item
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public function addToFile(\AppBundle/Soap/Play\DTO\FileType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \AppBundle/Soap/Play\DTO\FileType) {
            throw new \InvalidArgumentException(sprintf('The file property can only contain items of \AppBundle/Soap/Play\DTO\FileType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->file[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\EventType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
