<?php

namespace AppBundle/Soap/Play\Service;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Register Service
 * @subpackage Services
 */
class Register extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named registerEvents
     * Meta informations extracted from the WSDL
     * - documentation: Request: org.p4.esb.model.eventmanager.api.RegisterEventsRequestResponse: org.p4.esb.model.eventmanager.api.RegisterEventsResponseVersion: 0.2.0JavaDoc:
     * http://localhost:8181/hawtio/javadoc/org.p4.esb.model.eventmanager:eventmanager-api:0.2.0/
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AppBundle/Soap/Play\DTO\RegisterEventsRequest $registerEventsRequest
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse|bool
     */
    public function registerEvents(\AppBundle/Soap/Play\DTO\RegisterEventsRequest $registerEventsRequest)
    {
        try {
            $this->setResult(self::getSoapClient()->registerEvents($registerEventsRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
