<?php

namespace AppBundle/Soap/Play\DTO;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for registerEventsResponse DTO
 * Meta informations extracted from the WSDL
 * - type: tns:registerEventsResponse
 * @subpackage Structs
 */
class RegisterEventsResponse extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $id;
    /**
     * The responseCode
     * @var int
     */
    public $responseCode;
    /**
     * The responseMessage
     * @var string
     */
    public $responseMessage;
    /**
     * Constructor method for registerEventsResponse
     * @uses RegisterEventsResponse::setId()
     * @uses RegisterEventsResponse::setResponseCode()
     * @uses RegisterEventsResponse::setResponseMessage()
     * @param string $id
     * @param int $responseCode
     * @param string $responseMessage
     */
    public function __construct($id = null, $responseCode = null, $responseMessage = null)
    {
        $this
            ->setId($id)
            ->setResponseCode($responseCode)
            ->setResponseMessage($responseMessage);
    }
    /**
     * Get id value
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get responseCode value
     * @return int|null
     */
    public function getResponseCode()
    {
        return $this->responseCode;
    }
    /**
     * Set responseCode value
     * @param int $responseCode
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: int
        if (!is_null($responseCode) && !is_numeric($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($responseCode)), __LINE__);
        }
        $this->responseCode = $responseCode;
        return $this;
    }
    /**
     * Get responseMessage value
     * @return string|null
     */
    public function getResponseMessage()
    {
        return $this->responseMessage;
    }
    /**
     * Set responseMessage value
     * @param string $responseMessage
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse
     */
    public function setResponseMessage($responseMessage = null)
    {
        // validation for constraint: string
        if (!is_null($responseMessage) && !is_string($responseMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseMessage)), __LINE__);
        }
        $this->responseMessage = $responseMessage;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \AppBundle/Soap/Play\DTO\RegisterEventsResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
