<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTotalOpenAmount_input StructType
 * @subpackage Structs
 */
class GetTotalOpenAmount_input extends AbstractStructBase
{
    /**
     * The sourceID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sourceID;
    /**
     * The transactionID
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $transactionID;
    /**
     * The dial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $dial;
    /**
     * The customerID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $customerID;
    /**
     * Constructor method for getTotalOpenAmount_input
     * @uses GetTotalOpenAmount_input::setSourceID()
     * @uses GetTotalOpenAmount_input::setTransactionID()
     * @uses GetTotalOpenAmount_input::setDial()
     * @uses GetTotalOpenAmount_input::setCustomerID()
     * @param string $sourceID
     * @param string $transactionID
     * @param string $dial
     * @param string $customerID
     */
    public function __construct($sourceID = null, $transactionID = null, $dial = null, $customerID = null)
    {
        $this
            ->setSourceID($sourceID)
            ->setTransactionID($transactionID)
            ->setDial($dial)
            ->setCustomerID($customerID);
    }
    /**
     * Get sourceID value
     * @return string|null
     */
    public function getSourceID()
    {
        return $this->sourceID;
    }
    /**
     * Set sourceID value
     * @param string $sourceID
     * @return \StructType\GetTotalOpenAmount_input
     */
    public function setSourceID($sourceID = null)
    {
        // validation for constraint: string
        if (!is_null($sourceID) && !is_string($sourceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceID, true), gettype($sourceID)), __LINE__);
        }
        $this->sourceID = $sourceID;
        return $this;
    }
    /**
     * Get transactionID value
     * @return string|null
     */
    public function getTransactionID()
    {
        return $this->transactionID;
    }
    /**
     * Set transactionID value
     * @param string $transactionID
     * @return \StructType\GetTotalOpenAmount_input
     */
    public function setTransactionID($transactionID = null)
    {
        // validation for constraint: string
        if (!is_null($transactionID) && !is_string($transactionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionID, true), gettype($transactionID)), __LINE__);
        }
        $this->transactionID = $transactionID;
        return $this;
    }
    /**
     * Get dial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDial()
    {
        return isset($this->dial) ? $this->dial : null;
    }
    /**
     * Set dial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dial
     * @return \StructType\GetTotalOpenAmount_input
     */
    public function setDial($dial = null)
    {
        // validation for constraint: string
        if (!is_null($dial) && !is_string($dial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dial, true), gettype($dial)), __LINE__);
        }
        if (is_null($dial) || (is_array($dial) && empty($dial))) {
            unset($this->dial);
        } else {
            $this->dial = $dial;
        }
        return $this;
    }
    /**
     * Get customerID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerID()
    {
        return isset($this->customerID) ? $this->customerID : null;
    }
    /**
     * Set customerID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerID
     * @return \StructType\GetTotalOpenAmount_input
     */
    public function setCustomerID($customerID = null)
    {
        // validation for constraint: string
        if (!is_null($customerID) && !is_string($customerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerID, true), gettype($customerID)), __LINE__);
        }
        if (is_null($customerID) || (is_array($customerID) && empty($customerID))) {
            unset($this->customerID);
        } else {
            $this->customerID = $customerID;
        }
        return $this;
    }
}
