<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getTotalOpenAmount_output StructType
 * @subpackage Structs
 */
class GetTotalOpenAmount_output extends AbstractStructBase
{
    /**
     * The totalOpenAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $totalOpenAmount;
    /**
     * The error
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Error
     */
    public $error;
    /**
     * Constructor method for getTotalOpenAmount_output
     * @uses GetTotalOpenAmount_output::setTotalOpenAmount()
     * @uses GetTotalOpenAmount_output::setError()
     * @param string $totalOpenAmount
     * @param \StructType\Error $error
     */
    public function __construct($totalOpenAmount = null, \StructType\Error $error = null)
    {
        $this
            ->setTotalOpenAmount($totalOpenAmount)
            ->setError($error);
    }
    /**
     * Get totalOpenAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTotalOpenAmount()
    {
        return isset($this->totalOpenAmount) ? $this->totalOpenAmount : null;
    }
    /**
     * Set totalOpenAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $totalOpenAmount
     * @return \StructType\GetTotalOpenAmount_output
     */
    public function setTotalOpenAmount($totalOpenAmount = null)
    {
        // validation for constraint: string
        if (!is_null($totalOpenAmount) && !is_string($totalOpenAmount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalOpenAmount, true), gettype($totalOpenAmount)), __LINE__);
        }
        if (is_null($totalOpenAmount) || (is_array($totalOpenAmount) && empty($totalOpenAmount))) {
            unset($this->totalOpenAmount);
        } else {
            $this->totalOpenAmount = $totalOpenAmount;
        }
        return $this;
    }
    /**
     * Get error value
     * @return \StructType\Error|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * Set error value
     * @param \StructType\Error $error
     * @return \StructType\GetTotalOpenAmount_output
     */
    public function setError(\StructType\Error $error = null)
    {
        $this->error = $error;
        return $this;
    }
}
