<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getTotalOpenAmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTotalOpenAmount $parameters
     * @return \StructType\GetTotalOpenAmountResponse|bool
     */
    public function getTotalOpenAmount(\StructType\GetTotalOpenAmount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->getTotalOpenAmount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetTotalOpenAmountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
