<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applications StructType
 * @subpackage Structs
 */
class Applications extends AbstractStructBase
{
    /**
     * The application
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ApplicationType[]
     */
    public $application;
    /**
     * Constructor method for applications
     * @uses Applications::setApplication()
     * @param \StructType\ApplicationType[] $application
     */
    public function __construct(array $application = array())
    {
        $this
            ->setApplication($application);
    }
    /**
     * Get application value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ApplicationType[]|null
     */
    public function getApplication()
    {
        return isset($this->application) ? $this->application : null;
    }
    /**
     * This method is responsible for validating the values passed to the setApplication method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplication method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplicationForArrayConstraintsFromSetApplication(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $applicationsApplicationItem) {
            // validation for constraint: itemType
            if (!$applicationsApplicationItem instanceof \StructType\ApplicationType) {
                $invalidValues[] = is_object($applicationsApplicationItem) ? get_class($applicationsApplicationItem) : sprintf('%s(%s)', gettype($applicationsApplicationItem), var_export($applicationsApplicationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The application property can only contain items of type \StructType\ApplicationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set application value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicationType[] $application
     * @return \StructType\Applications
     */
    public function setApplication(array $application = array())
    {
        // validation for constraint: array
        if ('' !== ($applicationArrayErrorMessage = self::validateApplicationForArrayConstraintsFromSetApplication($application))) {
            throw new \InvalidArgumentException($applicationArrayErrorMessage, __LINE__);
        }
        if (is_null($application) || (is_array($application) && empty($application))) {
            unset($this->application);
        } else {
            $this->application = $application;
        }
        return $this;
    }
    /**
     * Add item to application value
     * @throws \InvalidArgumentException
     * @param \StructType\ApplicationType $item
     * @return \StructType\Applications
     */
    public function addToApplication(\StructType\ApplicationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ApplicationType) {
            throw new \InvalidArgumentException(sprintf('The application property can only contain items of type \StructType\ApplicationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->application[] = $item;
        return $this;
    }
}
