<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applicationType StructType
 * @subpackage Structs
 */
class ApplicationType extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $apiKey;
    /**
     * The secretKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $secretKey;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The accessType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessType;
    /**
     * The applicationType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $applicationType;
    /**
     * The descDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descDetail;
    /**
     * The registerDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $registerDate;
    /**
     * The successReturnUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $successReturnUrl;
    /**
     * The failReturnUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failReturnUrl;
    /**
     * Constructor method for applicationType
     * @uses ApplicationType::setApiKey()
     * @uses ApplicationType::setSecretKey()
     * @uses ApplicationType::setName()
     * @uses ApplicationType::setDescription()
     * @uses ApplicationType::setAccessType()
     * @uses ApplicationType::setApplicationType()
     * @uses ApplicationType::setDescDetail()
     * @uses ApplicationType::setRegisterDate()
     * @uses ApplicationType::setSuccessReturnUrl()
     * @uses ApplicationType::setFailReturnUrl()
     * @param string $apiKey
     * @param string $secretKey
     * @param string $name
     * @param string $description
     * @param string $accessType
     * @param string $applicationType
     * @param string $descDetail
     * @param string $registerDate
     * @param string $successReturnUrl
     * @param string $failReturnUrl
     */
    public function __construct($apiKey = null, $secretKey = null, $name = null, $description = null, $accessType = null, $applicationType = null, $descDetail = null, $registerDate = null, $successReturnUrl = null, $failReturnUrl = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setSecretKey($secretKey)
            ->setName($name)
            ->setDescription($description)
            ->setAccessType($accessType)
            ->setApplicationType($applicationType)
            ->setDescDetail($descDetail)
            ->setRegisterDate($registerDate)
            ->setSuccessReturnUrl($successReturnUrl)
            ->setFailReturnUrl($failReturnUrl);
    }
    /**
     * Get apiKey value
     * @return string|null
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\ApplicationType
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apiKey, true), gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get secretKey value
     * @return string|null
     */
    public function getSecretKey()
    {
        return $this->secretKey;
    }
    /**
     * Set secretKey value
     * @param string $secretKey
     * @return \StructType\ApplicationType
     */
    public function setSecretKey($secretKey = null)
    {
        // validation for constraint: string
        if (!is_null($secretKey) && !is_string($secretKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretKey, true), gettype($secretKey)), __LINE__);
        }
        $this->secretKey = $secretKey;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ApplicationType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ApplicationType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get accessType value
     * @return string|null
     */
    public function getAccessType()
    {
        return $this->accessType;
    }
    /**
     * Set accessType value
     * @param string $accessType
     * @return \StructType\ApplicationType
     */
    public function setAccessType($accessType = null)
    {
        // validation for constraint: string
        if (!is_null($accessType) && !is_string($accessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessType, true), gettype($accessType)), __LINE__);
        }
        $this->accessType = $accessType;
        return $this;
    }
    /**
     * Get applicationType value
     * @return string|null
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }
    /**
     * Set applicationType value
     * @param string $applicationType
     * @return \StructType\ApplicationType
     */
    public function setApplicationType($applicationType = null)
    {
        // validation for constraint: string
        if (!is_null($applicationType) && !is_string($applicationType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationType, true), gettype($applicationType)), __LINE__);
        }
        $this->applicationType = $applicationType;
        return $this;
    }
    /**
     * Get descDetail value
     * @return string|null
     */
    public function getDescDetail()
    {
        return $this->descDetail;
    }
    /**
     * Set descDetail value
     * @param string $descDetail
     * @return \StructType\ApplicationType
     */
    public function setDescDetail($descDetail = null)
    {
        // validation for constraint: string
        if (!is_null($descDetail) && !is_string($descDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descDetail, true), gettype($descDetail)), __LINE__);
        }
        $this->descDetail = $descDetail;
        return $this;
    }
    /**
     * Get registerDate value
     * @return string|null
     */
    public function getRegisterDate()
    {
        return $this->registerDate;
    }
    /**
     * Set registerDate value
     * @param string $registerDate
     * @return \StructType\ApplicationType
     */
    public function setRegisterDate($registerDate = null)
    {
        // validation for constraint: string
        if (!is_null($registerDate) && !is_string($registerDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registerDate, true), gettype($registerDate)), __LINE__);
        }
        $this->registerDate = $registerDate;
        return $this;
    }
    /**
     * Get successReturnUrl value
     * @return string|null
     */
    public function getSuccessReturnUrl()
    {
        return $this->successReturnUrl;
    }
    /**
     * Set successReturnUrl value
     * @param string $successReturnUrl
     * @return \StructType\ApplicationType
     */
    public function setSuccessReturnUrl($successReturnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($successReturnUrl) && !is_string($successReturnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($successReturnUrl, true), gettype($successReturnUrl)), __LINE__);
        }
        $this->successReturnUrl = $successReturnUrl;
        return $this;
    }
    /**
     * Get failReturnUrl value
     * @return string|null
     */
    public function getFailReturnUrl()
    {
        return $this->failReturnUrl;
    }
    /**
     * Set failReturnUrl value
     * @param string $failReturnUrl
     * @return \StructType\ApplicationType
     */
    public function setFailReturnUrl($failReturnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($failReturnUrl) && !is_string($failReturnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failReturnUrl, true), gettype($failReturnUrl)), __LINE__);
        }
        $this->failReturnUrl = $failReturnUrl;
        return $this;
    }
}
