<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applicationInfoType StructType
 * @subpackage Structs
 */
class ApplicationInfoType extends AbstractStructBase
{
    /**
     * The developerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $developerId;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The accessType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $accessType;
    /**
     * The appType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $appType;
    /**
     * The descDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descDetail;
    /**
     * The successReturnUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $successReturnUrl;
    /**
     * The failReturnUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $failReturnUrl;
    /**
     * Constructor method for applicationInfoType
     * @uses ApplicationInfoType::setDeveloperId()
     * @uses ApplicationInfoType::setName()
     * @uses ApplicationInfoType::setDescription()
     * @uses ApplicationInfoType::setAccessType()
     * @uses ApplicationInfoType::setAppType()
     * @uses ApplicationInfoType::setDescDetail()
     * @uses ApplicationInfoType::setSuccessReturnUrl()
     * @uses ApplicationInfoType::setFailReturnUrl()
     * @param string $developerId
     * @param string $name
     * @param string $description
     * @param string $accessType
     * @param string $appType
     * @param string $descDetail
     * @param string $successReturnUrl
     * @param string $failReturnUrl
     */
    public function __construct($developerId = null, $name = null, $description = null, $accessType = null, $appType = null, $descDetail = null, $successReturnUrl = null, $failReturnUrl = null)
    {
        $this
            ->setDeveloperId($developerId)
            ->setName($name)
            ->setDescription($description)
            ->setAccessType($accessType)
            ->setAppType($appType)
            ->setDescDetail($descDetail)
            ->setSuccessReturnUrl($successReturnUrl)
            ->setFailReturnUrl($failReturnUrl);
    }
    /**
     * Get developerId value
     * @return string|null
     */
    public function getDeveloperId()
    {
        return $this->developerId;
    }
    /**
     * Set developerId value
     * @param string $developerId
     * @return \StructType\ApplicationInfoType
     */
    public function setDeveloperId($developerId = null)
    {
        // validation for constraint: string
        if (!is_null($developerId) && !is_string($developerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerId, true), gettype($developerId)), __LINE__);
        }
        $this->developerId = $developerId;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\ApplicationInfoType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\ApplicationInfoType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get accessType value
     * @return string|null
     */
    public function getAccessType()
    {
        return $this->accessType;
    }
    /**
     * Set accessType value
     * @param string $accessType
     * @return \StructType\ApplicationInfoType
     */
    public function setAccessType($accessType = null)
    {
        // validation for constraint: string
        if (!is_null($accessType) && !is_string($accessType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessType, true), gettype($accessType)), __LINE__);
        }
        $this->accessType = $accessType;
        return $this;
    }
    /**
     * Get appType value
     * @return string|null
     */
    public function getAppType()
    {
        return $this->appType;
    }
    /**
     * Set appType value
     * @param string $appType
     * @return \StructType\ApplicationInfoType
     */
    public function setAppType($appType = null)
    {
        // validation for constraint: string
        if (!is_null($appType) && !is_string($appType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appType, true), gettype($appType)), __LINE__);
        }
        $this->appType = $appType;
        return $this;
    }
    /**
     * Get descDetail value
     * @return string|null
     */
    public function getDescDetail()
    {
        return $this->descDetail;
    }
    /**
     * Set descDetail value
     * @param string $descDetail
     * @return \StructType\ApplicationInfoType
     */
    public function setDescDetail($descDetail = null)
    {
        // validation for constraint: string
        if (!is_null($descDetail) && !is_string($descDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descDetail, true), gettype($descDetail)), __LINE__);
        }
        $this->descDetail = $descDetail;
        return $this;
    }
    /**
     * Get successReturnUrl value
     * @return string|null
     */
    public function getSuccessReturnUrl()
    {
        return $this->successReturnUrl;
    }
    /**
     * Set successReturnUrl value
     * @param string $successReturnUrl
     * @return \StructType\ApplicationInfoType
     */
    public function setSuccessReturnUrl($successReturnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($successReturnUrl) && !is_string($successReturnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($successReturnUrl, true), gettype($successReturnUrl)), __LINE__);
        }
        $this->successReturnUrl = $successReturnUrl;
        return $this;
    }
    /**
     * Get failReturnUrl value
     * @return string|null
     */
    public function getFailReturnUrl()
    {
        return $this->failReturnUrl;
    }
    /**
     * Set failReturnUrl value
     * @param string $failReturnUrl
     * @return \StructType\ApplicationInfoType
     */
    public function setFailReturnUrl($failReturnUrl = null)
    {
        // validation for constraint: string
        if (!is_null($failReturnUrl) && !is_string($failReturnUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($failReturnUrl, true), gettype($failReturnUrl)), __LINE__);
        }
        $this->failReturnUrl = $failReturnUrl;
        return $this;
    }
}
