<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Create ServiceType
 * @subpackage Services
 */
class Create extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named createApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ApplicationInfoType $applicationInfo
     * @param string $lang
     * @return \StructType\ApplicationServiceResponse|bool
     */
    public function createApplication(\StructType\ApplicationInfoType $applicationInfo, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->createApplication($applicationInfo, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ApplicationServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
