<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applicationServiceResponse StructType
 * @subpackage Structs
 */
class ApplicationServiceResponse extends BaseResponse
{
    /**
     * The application
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ApplicationType
     */
    public $application;
    /**
     * The developerId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $developerId;
    /**
     * Constructor method for applicationServiceResponse
     * @uses ApplicationServiceResponse::setApplication()
     * @uses ApplicationServiceResponse::setDeveloperId()
     * @param \StructType\ApplicationType $application
     * @param string $developerId
     */
    public function __construct(\StructType\ApplicationType $application = null, $developerId = null)
    {
        $this
            ->setApplication($application)
            ->setDeveloperId($developerId);
    }
    /**
     * Get application value
     * @return \StructType\ApplicationType|null
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param \StructType\ApplicationType $application
     * @return \StructType\ApplicationServiceResponse
     */
    public function setApplication(\StructType\ApplicationType $application = null)
    {
        $this->application = $application;
        return $this;
    }
    /**
     * Get developerId value
     * @return string|null
     */
    public function getDeveloperId()
    {
        return $this->developerId;
    }
    /**
     * Set developerId value
     * @param string $developerId
     * @return \StructType\ApplicationServiceResponse
     */
    public function setDeveloperId($developerId = null)
    {
        // validation for constraint: string
        if (!is_null($developerId) && !is_string($developerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($developerId, true), gettype($developerId)), __LINE__);
        }
        $this->developerId = $developerId;
        return $this;
    }
}
