<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for applicationServiceListResponse StructType
 * @subpackage Structs
 */
class ApplicationServiceListResponse extends BaseResponse
{
    /**
     * The applicationCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $applicationCount;
    /**
     * The applications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Applications
     */
    public $applications;
    /**
     * Constructor method for applicationServiceListResponse
     * @uses ApplicationServiceListResponse::setApplicationCount()
     * @uses ApplicationServiceListResponse::setApplications()
     * @param int $applicationCount
     * @param \StructType\Applications $applications
     */
    public function __construct($applicationCount = null, \StructType\Applications $applications = null)
    {
        $this
            ->setApplicationCount($applicationCount)
            ->setApplications($applications);
    }
    /**
     * Get applicationCount value
     * @return int|null
     */
    public function getApplicationCount()
    {
        return $this->applicationCount;
    }
    /**
     * Set applicationCount value
     * @param int $applicationCount
     * @return \StructType\ApplicationServiceListResponse
     */
    public function setApplicationCount($applicationCount = null)
    {
        // validation for constraint: int
        if (!is_null($applicationCount) && !(is_int($applicationCount) || ctype_digit($applicationCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($applicationCount, true), gettype($applicationCount)), __LINE__);
        }
        $this->applicationCount = $applicationCount;
        return $this;
    }
    /**
     * Get applications value
     * @return \StructType\Applications|null
     */
    public function getApplications()
    {
        return $this->applications;
    }
    /**
     * Set applications value
     * @param \StructType\Applications $applications
     * @return \StructType\ApplicationServiceListResponse
     */
    public function setApplications(\StructType\Applications $applications = null)
    {
        $this->applications = $applications;
        return $this;
    }
}
