<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Delete ServiceType
 * @subpackage Services
 */
class Delete extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named deleteApplication
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $developerId
     * @param string $apiKey
     * @param string $lang
     * @return \StructType\MessageServiceResponse|bool
     */
    public function deleteApplication($developerId, $apiKey, $lang)
    {
        try {
            $this->setResult($this->getSoapClient()->deleteApplication($developerId, $apiKey, $lang));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MessageServiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
