<?php

namespace EltaPrint\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for READ ServiceType
 * @subpackage Services
 */
class READ extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named READ
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \EltaPrint\StructType\READ $parameters
     * @return \EltaPrint\StructType\READResponse|bool
     */
    public function READ(\EltaPrint\StructType\READ $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->READ($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \EltaPrint\StructType\READResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
