<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcctRequestToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathAcctRequestToken extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The accountid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountid;
    /**
     * The accountsecuritykey
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountsecuritykey;
    /**
     * Constructor method for AcctRequestToken
     * @uses PathAcctRequestToken::setVendorid()
     * @uses PathAcctRequestToken::setVendorpw()
     * @uses PathAcctRequestToken::setAccountid()
     * @uses PathAcctRequestToken::setAccountsecuritykey()
     * @param string $vendorid
     * @param string $vendorpw
     * @param string $accountid
     * @param string $accountsecuritykey
     */
    public function __construct($vendorid = null, $vendorpw = null, $accountid = null, $accountsecuritykey = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setVendorpw($vendorpw)
            ->setAccountid($accountid)
            ->setAccountsecuritykey($accountsecuritykey);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathAcctRequestToken
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathAcctRequestToken
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get accountid value
     * @return string|null
     */
    public function getAccountid()
    {
        return $this->accountid;
    }
    /**
     * Set accountid value
     * @param string $accountid
     * @return \Path\pathStructType\PathAcctRequestToken
     */
    public function setAccountid($accountid = null)
    {
        // validation for constraint: string
        if (!is_null($accountid) && !is_string($accountid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountid, true), gettype($accountid)), __LINE__);
        }
        $this->accountid = $accountid;
        return $this;
    }
    /**
     * Get accountsecuritykey value
     * @return string|null
     */
    public function getAccountsecuritykey()
    {
        return $this->accountsecuritykey;
    }
    /**
     * Set accountsecuritykey value
     * @param string $accountsecuritykey
     * @return \Path\pathStructType\PathAcctRequestToken
     */
    public function setAccountsecuritykey($accountsecuritykey = null)
    {
        // validation for constraint: string
        if (!is_null($accountsecuritykey) && !is_string($accountsecuritykey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountsecuritykey, true), gettype($accountsecuritykey)), __LINE__);
        }
        $this->accountsecuritykey = $accountsecuritykey;
        return $this;
    }
}
