<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Set pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathSet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SetLoanDataByToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathSetLoanDataByToken $parameters
     * @return \Path\pathStructType\PathSetLoanDataByTokenResponse|bool
     */
    public function SetLoanDataByToken(\Path\pathStructType\PathSetLoanDataByToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SetLoanDataByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathSetLoanDataByTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
