<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultSet pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultSet extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathStructType\PathReportDataSet
     */
    public $Data;
    /**
     * Constructor method for ResultSet
     * @uses PathResultSet::setStatus()
     * @uses PathResultSet::setData()
     * @param int $status
     * @param \Path\pathStructType\PathReportDataSet $data
     */
    public function __construct($status = null, \Path\pathStructType\PathReportDataSet $data = null)
    {
        $this
            ->setStatus($status)
            ->setData($data);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultSet
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Data value
     * @return \Path\pathStructType\PathReportDataSet|null
     */
    public function getData()
    {
        return $this->Data;
    }
    /**
     * Set Data value
     * @param \Path\pathStructType\PathReportDataSet $data
     * @return \Path\pathStructType\PathResultSet
     */
    public function setData(\Path\pathStructType\PathReportDataSet $data = null)
    {
        $this->Data = $data;
        return $this;
    }
}
