<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetTemplateDefinedLoanDataByToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathGetTemplateDefinedLoanDataByToken extends AbstractStructBase
{
    /**
     * The roleid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $roleid;
    /**
     * The templateid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $templateid;
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * Constructor method for GetTemplateDefinedLoanDataByToken
     * @uses PathGetTemplateDefinedLoanDataByToken::setRoleid()
     * @uses PathGetTemplateDefinedLoanDataByToken::setTemplateid()
     * @uses PathGetTemplateDefinedLoanDataByToken::setVendorid()
     * @uses PathGetTemplateDefinedLoanDataByToken::setApitoken()
     * @uses PathGetTemplateDefinedLoanDataByToken::setVendorpw()
     * @param int $roleid
     * @param int $templateid
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     */
    public function __construct($roleid = null, $templateid = null, $vendorid = null, $apitoken = null, $vendorpw = null)
    {
        $this
            ->setRoleid($roleid)
            ->setTemplateid($templateid)
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw);
    }
    /**
     * Get roleid value
     * @return int
     */
    public function getRoleid()
    {
        return $this->roleid;
    }
    /**
     * Set roleid value
     * @param int $roleid
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken
     */
    public function setRoleid($roleid = null)
    {
        // validation for constraint: int
        if (!is_null($roleid) && !(is_int($roleid) || ctype_digit($roleid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleid, true), gettype($roleid)), __LINE__);
        }
        $this->roleid = $roleid;
        return $this;
    }
    /**
     * Get templateid value
     * @return int
     */
    public function getTemplateid()
    {
        return $this->templateid;
    }
    /**
     * Set templateid value
     * @param int $templateid
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken
     */
    public function setTemplateid($templateid = null)
    {
        // validation for constraint: int
        if (!is_null($templateid) && !(is_int($templateid) || ctype_digit($templateid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateid, true), gettype($templateid)), __LINE__);
        }
        $this->templateid = $templateid;
        return $this;
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apitoken, true), gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
}
