<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathDocumentInfo extends AbstractStructBase
{
    /**
     * The docid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $docid;
    /**
     * The documentname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documentname;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $description;
    /**
     * The documenttype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $documenttype;
    /**
     * Constructor method for DocumentInfo
     * @uses PathDocumentInfo::setDocid()
     * @uses PathDocumentInfo::setDocumentname()
     * @uses PathDocumentInfo::setDescription()
     * @uses PathDocumentInfo::setDocumenttype()
     * @param int $docid
     * @param string $documentname
     * @param string $description
     * @param string $documenttype
     */
    public function __construct($docid = null, $documentname = null, $description = null, $documenttype = null)
    {
        $this
            ->setDocid($docid)
            ->setDocumentname($documentname)
            ->setDescription($description)
            ->setDocumenttype($documenttype);
    }
    /**
     * Get docid value
     * @return int
     */
    public function getDocid()
    {
        return $this->docid;
    }
    /**
     * Set docid value
     * @param int $docid
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocid($docid = null)
    {
        // validation for constraint: int
        if (!is_null($docid) && !(is_int($docid) || ctype_digit($docid))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($docid, true), gettype($docid)), __LINE__);
        }
        $this->docid = $docid;
        return $this;
    }
    /**
     * Get documentname value
     * @return string|null
     */
    public function getDocumentname()
    {
        return $this->documentname;
    }
    /**
     * Set documentname value
     * @param string $documentname
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocumentname($documentname = null)
    {
        // validation for constraint: string
        if (!is_null($documentname) && !is_string($documentname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentname, true), gettype($documentname)), __LINE__);
        }
        $this->documentname = $documentname;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get documenttype value
     * @return string|null
     */
    public function getDocumenttype()
    {
        return $this->documenttype;
    }
    /**
     * Set documenttype value
     * @param string $documenttype
     * @return \Path\pathStructType\PathDocumentInfo
     */
    public function setDocumenttype($documenttype = null)
    {
        // validation for constraint: string
        if (!is_null($documenttype) && !is_string($documenttype)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documenttype, true), gettype($documenttype)), __LINE__);
        }
        $this->documenttype = $documenttype;
        return $this;
    }
}
