<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetLoanDataByToken pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathSetLoanDataByToken extends AbstractStructBase
{
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The apitoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $apitoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The loandata
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfLoanKeyValuePair1
     */
    public $loandata;
    /**
     * Constructor method for SetLoanDataByToken
     * @uses PathSetLoanDataByToken::setVendorid()
     * @uses PathSetLoanDataByToken::setApitoken()
     * @uses PathSetLoanDataByToken::setVendorpw()
     * @uses PathSetLoanDataByToken::setLoandata()
     * @param string $vendorid
     * @param string $apitoken
     * @param string $vendorpw
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata
     */
    public function __construct($vendorid = null, $apitoken = null, $vendorpw = null, \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata = null)
    {
        $this
            ->setVendorid($vendorid)
            ->setApitoken($apitoken)
            ->setVendorpw($vendorpw)
            ->setLoandata($loandata);
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get apitoken value
     * @return string|null
     */
    public function getApitoken()
    {
        return $this->apitoken;
    }
    /**
     * Set apitoken value
     * @param string $apitoken
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setApitoken($apitoken = null)
    {
        // validation for constraint: string
        if (!is_null($apitoken) && !is_string($apitoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apitoken, true), gettype($apitoken)), __LINE__);
        }
        $this->apitoken = $apitoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get loandata value
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair1|null
     */
    public function getLoandata()
    {
        return $this->loandata;
    }
    /**
     * Set loandata value
     * @param \Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata
     * @return \Path\pathStructType\PathSetLoanDataByToken
     */
    public function setLoandata(\Path\pathArrayType\PathArrayOfLoanKeyValuePair1 $loandata = null)
    {
        $this->loandata = $loandata;
        return $this;
    }
}
