<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Request pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathRequest extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RequestLoanToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathRequestLoanToken $parameters
     * @return \Path\pathStructType\PathRequestLoanTokenResponse|bool
     */
    public function RequestLoanToken(\Path\pathStructType\PathRequestLoanToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RequestLoanToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathRequestLoanTokenResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
