<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLoanKeyValuePair pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfLoanKeyValuePair extends AbstractStructArrayBase
{
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathLoanKeyValuePair[]
     */
    public $Values;
    /**
     * Constructor method for ArrayOfLoanKeyValuePair
     * @uses PathArrayOfLoanKeyValuePair::setValues()
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $values
     */
    public function __construct(array $values = array())
    {
        $this
            ->setValues($values);
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathLoanKeyValuePair[]|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * This method is responsible for validating the values passed to the setValues method
     * This method is willingly generated in order to preserve the one-line inline validation within the setValues method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateValuesForArrayConstraintsFromSetValues(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLoanKeyValuePairValuesItem) {
            // validation for constraint: itemType
            if (!$arrayOfLoanKeyValuePairValuesItem instanceof \Path\pathStructType\PathLoanKeyValuePair) {
                $invalidValues[] = is_object($arrayOfLoanKeyValuePairValuesItem) ? get_class($arrayOfLoanKeyValuePairValuesItem) : sprintf('%s(%s)', gettype($arrayOfLoanKeyValuePairValuesItem), var_export($arrayOfLoanKeyValuePairValuesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Values property can only contain items of type \Path\pathStructType\PathLoanKeyValuePair, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair[] $values
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public function setValues(array $values = array())
    {
        // validation for constraint: array
        if ('' !== ($valuesArrayErrorMessage = self::validateValuesForArrayConstraintsFromSetValues($values))) {
            throw new \InvalidArgumentException($valuesArrayErrorMessage, __LINE__);
        }
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
    /**
     * Add item to Values value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathLoanKeyValuePair $item
     * @return \Path\pathArrayType\PathArrayOfLoanKeyValuePair
     */
    public function addToValues(\Path\pathStructType\PathLoanKeyValuePair $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathLoanKeyValuePair) {
            throw new \InvalidArgumentException(sprintf('The Values property can only contain items of type \Path\pathStructType\PathLoanKeyValuePair, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Values[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathLoanKeyValuePair|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Values
     */
    public function getAttributeName()
    {
        return 'Values';
    }
}
