<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TemplateInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathTemplateInfo extends AbstractStructBase
{
    /**
     * The TemplateId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $TemplateId;
    /**
     * The RoleId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $RoleId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RoleName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoleName;
    /**
     * Constructor method for TemplateInfo
     * @uses PathTemplateInfo::setTemplateId()
     * @uses PathTemplateInfo::setRoleId()
     * @uses PathTemplateInfo::setName()
     * @uses PathTemplateInfo::setRoleName()
     * @param int $templateId
     * @param int $roleId
     * @param string $name
     * @param string $roleName
     */
    public function __construct($templateId = null, $roleId = null, $name = null, $roleName = null)
    {
        $this
            ->setTemplateId($templateId)
            ->setRoleId($roleId)
            ->setName($name)
            ->setRoleName($roleName);
    }
    /**
     * Get TemplateId value
     * @return int
     */
    public function getTemplateId()
    {
        return $this->TemplateId;
    }
    /**
     * Set TemplateId value
     * @param int $templateId
     * @return \Path\pathStructType\PathTemplateInfo
     */
    public function setTemplateId($templateId = null)
    {
        // validation for constraint: int
        if (!is_null($templateId) && !(is_int($templateId) || ctype_digit($templateId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($templateId, true), gettype($templateId)), __LINE__);
        }
        $this->TemplateId = $templateId;
        return $this;
    }
    /**
     * Get RoleId value
     * @return int
     */
    public function getRoleId()
    {
        return $this->RoleId;
    }
    /**
     * Set RoleId value
     * @param int $roleId
     * @return \Path\pathStructType\PathTemplateInfo
     */
    public function setRoleId($roleId = null)
    {
        // validation for constraint: int
        if (!is_null($roleId) && !(is_int($roleId) || ctype_digit($roleId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($roleId, true), gettype($roleId)), __LINE__);
        }
        $this->RoleId = $roleId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Path\pathStructType\PathTemplateInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RoleName value
     * @return string|null
     */
    public function getRoleName()
    {
        return $this->RoleName;
    }
    /**
     * Set RoleName value
     * @param string $roleName
     * @return \Path\pathStructType\PathTemplateInfo
     */
    public function setRoleName($roleName = null)
    {
        // validation for constraint: string
        if (!is_null($roleName) && !is_string($roleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roleName, true), gettype($roleName)), __LINE__);
        }
        $this->RoleName = $roleName;
        return $this;
    }
}
