<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultFeeList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultFeeList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The FeeList
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfFeeConfigured
     */
    public $FeeList;
    /**
     * Constructor method for ResultFeeList
     * @uses PathResultFeeList::setStatus()
     * @uses PathResultFeeList::setMessage()
     * @uses PathResultFeeList::setFeeList()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfFeeConfigured $feeList
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfFeeConfigured $feeList = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setFeeList($feeList);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultFeeList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultFeeList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get FeeList value
     * @return \Path\pathArrayType\PathArrayOfFeeConfigured|null
     */
    public function getFeeList()
    {
        return $this->FeeList;
    }
    /**
     * Set FeeList value
     * @param \Path\pathArrayType\PathArrayOfFeeConfigured $feeList
     * @return \Path\pathStructType\PathResultFeeList
     */
    public function setFeeList(\Path\pathArrayType\PathArrayOfFeeConfigured $feeList = null)
    {
        $this->FeeList = $feeList;
        return $this;
    }
}
