<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResultDocList pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathResultDocList extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The Message
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Message;
    /**
     * The docinfolist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfDocumentInfo
     */
    public $docinfolist;
    /**
     * Constructor method for ResultDocList
     * @uses PathResultDocList::setStatus()
     * @uses PathResultDocList::setMessage()
     * @uses PathResultDocList::setDocinfolist()
     * @param int $status
     * @param string $message
     * @param \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist
     */
    public function __construct($status = null, $message = null, \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist = null)
    {
        $this
            ->setStatus($status)
            ->setMessage($message)
            ->setDocinfolist($docinfolist);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
    /**
     * Get docinfolist value
     * @return \Path\pathArrayType\PathArrayOfDocumentInfo|null
     */
    public function getDocinfolist()
    {
        return $this->docinfolist;
    }
    /**
     * Set docinfolist value
     * @param \Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist
     * @return \Path\pathStructType\PathResultDocList
     */
    public function setDocinfolist(\Path\pathArrayType\PathArrayOfDocumentInfo $docinfolist = null)
    {
        $this->docinfolist = $docinfolist;
        return $this;
    }
}
