<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OUInfo pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathOUInfo extends AbstractStructBase
{
    /**
     * The OUID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OUID;
    /**
     * The OriginationAuthority
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $OriginationAuthority;
    /**
     * The OUName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OUName;
    /**
     * Constructor method for OUInfo
     * @uses PathOUInfo::setOUID()
     * @uses PathOUInfo::setOriginationAuthority()
     * @uses PathOUInfo::setOUName()
     * @param int $oUID
     * @param bool $originationAuthority
     * @param string $oUName
     */
    public function __construct($oUID = null, $originationAuthority = null, $oUName = null)
    {
        $this
            ->setOUID($oUID)
            ->setOriginationAuthority($originationAuthority)
            ->setOUName($oUName);
    }
    /**
     * Get OUID value
     * @return int
     */
    public function getOUID()
    {
        return $this->OUID;
    }
    /**
     * Set OUID value
     * @param int $oUID
     * @return \Path\pathStructType\PathOUInfo
     */
    public function setOUID($oUID = null)
    {
        // validation for constraint: int
        if (!is_null($oUID) && !(is_int($oUID) || ctype_digit($oUID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oUID, true), gettype($oUID)), __LINE__);
        }
        $this->OUID = $oUID;
        return $this;
    }
    /**
     * Get OriginationAuthority value
     * @return bool
     */
    public function getOriginationAuthority()
    {
        return $this->OriginationAuthority;
    }
    /**
     * Set OriginationAuthority value
     * @param bool $originationAuthority
     * @return \Path\pathStructType\PathOUInfo
     */
    public function setOriginationAuthority($originationAuthority = null)
    {
        // validation for constraint: boolean
        if (!is_null($originationAuthority) && !is_bool($originationAuthority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($originationAuthority, true), gettype($originationAuthority)), __LINE__);
        }
        $this->OriginationAuthority = $originationAuthority;
        return $this;
    }
    /**
     * Get OUName value
     * @return string|null
     */
    public function getOUName()
    {
        return $this->OUName;
    }
    /**
     * Set OUName value
     * @param string $oUName
     * @return \Path\pathStructType\PathOUInfo
     */
    public function setOUName($oUName = null)
    {
        // validation for constraint: string
        if (!is_null($oUName) && !is_string($oUName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oUName, true), gettype($oUName)), __LINE__);
        }
        $this->OUName = $oUName;
        return $this;
    }
}
