<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeConfigured pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathFeeConfigured extends AbstractStructBase
{
    /**
     * The FeeName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeName;
    /**
     * The FeeType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeType;
    /**
     * The FeeSection
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FeeSection;
    /**
     * Constructor method for FeeConfigured
     * @uses PathFeeConfigured::setFeeName()
     * @uses PathFeeConfigured::setFeeType()
     * @uses PathFeeConfigured::setFeeSection()
     * @param string $feeName
     * @param string $feeType
     * @param string $feeSection
     */
    public function __construct($feeName = null, $feeType = null, $feeSection = null)
    {
        $this
            ->setFeeName($feeName)
            ->setFeeType($feeType)
            ->setFeeSection($feeSection);
    }
    /**
     * Get FeeName value
     * @return string|null
     */
    public function getFeeName()
    {
        return $this->FeeName;
    }
    /**
     * Set FeeName value
     * @param string $feeName
     * @return \Path\pathStructType\PathFeeConfigured
     */
    public function setFeeName($feeName = null)
    {
        // validation for constraint: string
        if (!is_null($feeName) && !is_string($feeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeName, true), gettype($feeName)), __LINE__);
        }
        $this->FeeName = $feeName;
        return $this;
    }
    /**
     * Get FeeType value
     * @return string|null
     */
    public function getFeeType()
    {
        return $this->FeeType;
    }
    /**
     * Set FeeType value
     * @param string $feeType
     * @return \Path\pathStructType\PathFeeConfigured
     */
    public function setFeeType($feeType = null)
    {
        // validation for constraint: string
        if (!is_null($feeType) && !is_string($feeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeType, true), gettype($feeType)), __LINE__);
        }
        $this->FeeType = $feeType;
        return $this;
    }
    /**
     * Get FeeSection value
     * @return string|null
     */
    public function getFeeSection()
    {
        return $this->FeeSection;
    }
    /**
     * Set FeeSection value
     * @param string $feeSection
     * @return \Path\pathStructType\PathFeeConfigured
     */
    public function setFeeSection($feeSection = null)
    {
        // validation for constraint: string
        if (!is_null($feeSection) && !is_string($feeSection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeSection, true), gettype($feeSection)), __LINE__);
        }
        $this->FeeSection = $feeSection;
        return $this;
    }
}
