<?php

namespace Path\pathStructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AcctSearchLoan pathStructType
 * @package Path
 * @subpackage Structs
 */
class PathAcctSearchLoan extends AbstractStructBase
{
    /**
     * The loantype
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $loantype;
    /**
     * The vendorid
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorid;
    /**
     * The accountaccesstoken
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountaccesstoken;
    /**
     * The vendorpw
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vendorpw;
    /**
     * The bulist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $bulist;
    /**
     * The conditionbyfield
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $conditionbyfield;
    /**
     * The conditionbystatusdate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Path\pathArrayType\PathArrayOfString
     */
    public $conditionbystatusdate;
    /**
     * Constructor method for AcctSearchLoan
     * @uses PathAcctSearchLoan::setLoantype()
     * @uses PathAcctSearchLoan::setVendorid()
     * @uses PathAcctSearchLoan::setAccountaccesstoken()
     * @uses PathAcctSearchLoan::setVendorpw()
     * @uses PathAcctSearchLoan::setBulist()
     * @uses PathAcctSearchLoan::setConditionbyfield()
     * @uses PathAcctSearchLoan::setConditionbystatusdate()
     * @param int $loantype
     * @param string $vendorid
     * @param string $accountaccesstoken
     * @param string $vendorpw
     * @param \Path\pathArrayType\PathArrayOfString $bulist
     * @param \Path\pathArrayType\PathArrayOfString $conditionbyfield
     * @param \Path\pathArrayType\PathArrayOfString $conditionbystatusdate
     */
    public function __construct($loantype = null, $vendorid = null, $accountaccesstoken = null, $vendorpw = null, \Path\pathArrayType\PathArrayOfString $bulist = null, \Path\pathArrayType\PathArrayOfString $conditionbyfield = null, \Path\pathArrayType\PathArrayOfString $conditionbystatusdate = null)
    {
        $this
            ->setLoantype($loantype)
            ->setVendorid($vendorid)
            ->setAccountaccesstoken($accountaccesstoken)
            ->setVendorpw($vendorpw)
            ->setBulist($bulist)
            ->setConditionbyfield($conditionbyfield)
            ->setConditionbystatusdate($conditionbystatusdate);
    }
    /**
     * Get loantype value
     * @return int
     */
    public function getLoantype()
    {
        return $this->loantype;
    }
    /**
     * Set loantype value
     * @param int $loantype
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setLoantype($loantype = null)
    {
        // validation for constraint: int
        if (!is_null($loantype) && !(is_int($loantype) || ctype_digit($loantype))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($loantype, true), gettype($loantype)), __LINE__);
        }
        $this->loantype = $loantype;
        return $this;
    }
    /**
     * Get vendorid value
     * @return string|null
     */
    public function getVendorid()
    {
        return $this->vendorid;
    }
    /**
     * Set vendorid value
     * @param string $vendorid
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setVendorid($vendorid = null)
    {
        // validation for constraint: string
        if (!is_null($vendorid) && !is_string($vendorid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorid, true), gettype($vendorid)), __LINE__);
        }
        $this->vendorid = $vendorid;
        return $this;
    }
    /**
     * Get accountaccesstoken value
     * @return string|null
     */
    public function getAccountaccesstoken()
    {
        return $this->accountaccesstoken;
    }
    /**
     * Set accountaccesstoken value
     * @param string $accountaccesstoken
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setAccountaccesstoken($accountaccesstoken = null)
    {
        // validation for constraint: string
        if (!is_null($accountaccesstoken) && !is_string($accountaccesstoken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountaccesstoken, true), gettype($accountaccesstoken)), __LINE__);
        }
        $this->accountaccesstoken = $accountaccesstoken;
        return $this;
    }
    /**
     * Get vendorpw value
     * @return string|null
     */
    public function getVendorpw()
    {
        return $this->vendorpw;
    }
    /**
     * Set vendorpw value
     * @param string $vendorpw
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setVendorpw($vendorpw = null)
    {
        // validation for constraint: string
        if (!is_null($vendorpw) && !is_string($vendorpw)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vendorpw, true), gettype($vendorpw)), __LINE__);
        }
        $this->vendorpw = $vendorpw;
        return $this;
    }
    /**
     * Get bulist value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getBulist()
    {
        return $this->bulist;
    }
    /**
     * Set bulist value
     * @param \Path\pathArrayType\PathArrayOfString $bulist
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setBulist(\Path\pathArrayType\PathArrayOfString $bulist = null)
    {
        $this->bulist = $bulist;
        return $this;
    }
    /**
     * Get conditionbyfield value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getConditionbyfield()
    {
        return $this->conditionbyfield;
    }
    /**
     * Set conditionbyfield value
     * @param \Path\pathArrayType\PathArrayOfString $conditionbyfield
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setConditionbyfield(\Path\pathArrayType\PathArrayOfString $conditionbyfield = null)
    {
        $this->conditionbyfield = $conditionbyfield;
        return $this;
    }
    /**
     * Get conditionbystatusdate value
     * @return \Path\pathArrayType\PathArrayOfString|null
     */
    public function getConditionbystatusdate()
    {
        return $this->conditionbystatusdate;
    }
    /**
     * Set conditionbystatusdate value
     * @param \Path\pathArrayType\PathArrayOfString $conditionbystatusdate
     * @return \Path\pathStructType\PathAcctSearchLoan
     */
    public function setConditionbystatusdate(\Path\pathArrayType\PathArrayOfString $conditionbystatusdate = null)
    {
        $this->conditionbystatusdate = $conditionbystatusdate;
        return $this;
    }
}
