<?php

namespace Path\pathServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get pathServiceType
 * @package Path
 * @subpackage Services
 */
class PathGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetLoanDataByToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetLoanDataByToken $parameters
     * @return \Path\pathStructType\PathGetLoanDataByTokenResponse|bool
     */
    public function GetLoanDataByToken(\Path\pathStructType\PathGetLoanDataByToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoanDataByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoanXMLByToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetLoanXMLByToken $parameters
     * @return \Path\pathStructType\PathGetLoanXMLByTokenResponse|bool
     */
    public function GetLoanXMLByToken(\Path\pathStructType\PathGetLoanXMLByToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoanXMLByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSSOTokenedURL
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetSSOTokenedURL $parameters
     * @return \Path\pathStructType\PathGetSSOTokenedURLResponse|bool
     */
    public function GetSSOTokenedURL(\Path\pathStructType\PathGetSSOTokenedURL $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSSOTokenedURL($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoanFeeData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetLoanFeeData $parameters
     * @return \Path\pathStructType\PathGetLoanFeeDataResponse|bool
     */
    public function GetLoanFeeData(\Path\pathStructType\PathGetLoanFeeData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoanFeeData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetLoanFeeData2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetLoanFeeData2 $parameters
     * @return \Path\pathStructType\PathGetLoanFeeData2Response|bool
     */
    public function GetLoanFeeData2(\Path\pathStructType\PathGetLoanFeeData2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetLoanFeeData2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentList
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetDocumentList $parameters
     * @return \Path\pathStructType\PathGetDocumentListResponse|bool
     */
    public function GetDocumentList(\Path\pathStructType\PathGetDocumentList $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDocumentFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetDocumentFile $parameters
     * @return \Path\pathStructType\PathGetDocumentFileResponse|bool
     */
    public function GetDocumentFile(\Path\pathStructType\PathGetDocumentFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDocumentFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetUserName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetUserName $parameters
     * @return \Path\pathStructType\PathGetUserNameResponse|bool
     */
    public function GetUserName(\Path\pathStructType\PathGetUserName $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetUserName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTemplateDefinedLoanDataByToken
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Path\pathStructType\PathGetTemplateDefinedLoanDataByToken $parameters
     * @return \Path\pathStructType\PathGetTemplateDefinedLoanDataByTokenResponse|bool
     */
    public function GetTemplateDefinedLoanDataByToken(\Path\pathStructType\PathGetTemplateDefinedLoanDataByToken $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTemplateDefinedLoanDataByToken($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Path\pathStructType\PathGetDocumentFileResponse|\Path\pathStructType\PathGetDocumentListResponse|\Path\pathStructType\PathGetLoanDataByTokenResponse|\Path\pathStructType\PathGetLoanFeeData2Response|\Path\pathStructType\PathGetLoanFeeDataResponse|\Path\pathStructType\PathGetLoanXMLByTokenResponse|\Path\pathStructType\PathGetSSOTokenedURLResponse|\Path\pathStructType\PathGetTemplateDefinedLoanDataByTokenResponse|\Path\pathStructType\PathGetUserNameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
