<?php

namespace Path\pathArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfRoleOUAccessInfo pathArrayType
 * @package Path
 * @subpackage Arrays
 */
class PathArrayOfRoleOUAccessInfo extends AbstractStructArrayBase
{
    /**
     * The RoleOUAccessInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \Path\pathStructType\PathRoleOUAccessInfo[]
     */
    public $RoleOUAccessInfo;
    /**
     * Constructor method for ArrayOfRoleOUAccessInfo
     * @uses PathArrayOfRoleOUAccessInfo::setRoleOUAccessInfo()
     * @param \Path\pathStructType\PathRoleOUAccessInfo[] $roleOUAccessInfo
     */
    public function __construct(array $roleOUAccessInfo = array())
    {
        $this
            ->setRoleOUAccessInfo($roleOUAccessInfo);
    }
    /**
     * Get RoleOUAccessInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \Path\pathStructType\PathRoleOUAccessInfo[]|null
     */
    public function getRoleOUAccessInfo()
    {
        return isset($this->RoleOUAccessInfo) ? $this->RoleOUAccessInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRoleOUAccessInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoleOUAccessInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoleOUAccessInfoForArrayConstraintsFromSetRoleOUAccessInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfRoleOUAccessInfoRoleOUAccessInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfRoleOUAccessInfoRoleOUAccessInfoItem instanceof \Path\pathStructType\PathRoleOUAccessInfo) {
                $invalidValues[] = is_object($arrayOfRoleOUAccessInfoRoleOUAccessInfoItem) ? get_class($arrayOfRoleOUAccessInfoRoleOUAccessInfoItem) : sprintf('%s(%s)', gettype($arrayOfRoleOUAccessInfoRoleOUAccessInfoItem), var_export($arrayOfRoleOUAccessInfoRoleOUAccessInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoleOUAccessInfo property can only contain items of type \Path\pathStructType\PathRoleOUAccessInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoleOUAccessInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathRoleOUAccessInfo[] $roleOUAccessInfo
     * @return \Path\pathArrayType\PathArrayOfRoleOUAccessInfo
     */
    public function setRoleOUAccessInfo(array $roleOUAccessInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($roleOUAccessInfoArrayErrorMessage = self::validateRoleOUAccessInfoForArrayConstraintsFromSetRoleOUAccessInfo($roleOUAccessInfo))) {
            throw new \InvalidArgumentException($roleOUAccessInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($roleOUAccessInfo) || (is_array($roleOUAccessInfo) && empty($roleOUAccessInfo))) {
            unset($this->RoleOUAccessInfo);
        } else {
            $this->RoleOUAccessInfo = $roleOUAccessInfo;
        }
        return $this;
    }
    /**
     * Add item to RoleOUAccessInfo value
     * @throws \InvalidArgumentException
     * @param \Path\pathStructType\PathRoleOUAccessInfo $item
     * @return \Path\pathArrayType\PathArrayOfRoleOUAccessInfo
     */
    public function addToRoleOUAccessInfo(\Path\pathStructType\PathRoleOUAccessInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \Path\pathStructType\PathRoleOUAccessInfo) {
            throw new \InvalidArgumentException(sprintf('The RoleOUAccessInfo property can only contain items of type \Path\pathStructType\PathRoleOUAccessInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoleOUAccessInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \Path\pathStructType\PathRoleOUAccessInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \Path\pathStructType\PathRoleOUAccessInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \Path\pathStructType\PathRoleOUAccessInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \Path\pathStructType\PathRoleOUAccessInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \Path\pathStructType\PathRoleOUAccessInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string RoleOUAccessInfo
     */
    public function getAttributeName()
    {
        return 'RoleOUAccessInfo';
    }
}
